//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: LogNormal.c,v 0.30 1996-08-07 18:01:32+02 steppler Exp $
 *
 * CNClass: CNLogNormal --- Log-normal distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "LogNormal.h"




void CNLogNormal::setState()
{
    double m2 = logMean * logMean;
    pMean = log(m2 / sqrt(logVariance + m2) );
// from ch@heike.informatik.uni-dortmund.de:
// (was pVariance = log((sqrt(logVariance + m2)/m2 )); )
    pStdDev = sqrt(log((logVariance + m2)/m2 ));
    pVariance = pStdDev*pStdDev;          // this line added
}

CNLogNormal::CNLogNormal(double mean, double variance, CNRNG *gen)
    : CNNormal(0, 0, gen)
{
    logMean = mean;
    logVariance = variance;
    setState();
}

double CNLogNormal::mean() {
    return logMean;
}

double CNLogNormal::mean(double x)
{
    double t=logMean; 
    logMean = x; 
    setState();
    return t;
}

double CNLogNormal::variance() {
    return logVariance;
}

double CNLogNormal::variance(double x)
{
    double t = logVariance; 
    logVariance = x; 
    setState();
    return t;
}



double CNLogNormal::operator()()
{
    return( pow(M_E, this->CNNormal::operator()() ) );
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNLogNormal::print(ostream &strm) const
{
    strm << "mean = " << logMean << " var = " << logVariance
	 << " (CNNormal mean = " << pMean << " var = " << pVariance << ")"
	 << endl;
}

// Debug output
void CNLogNormal::dump(ostream &strm) const
{
    strm << "CNLogNormal { "
	 << "mean = " << logMean << " var = " << logVariance
	 << " (CNNormal mean = " << pMean << " var = " << pVariance << ")"
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNLogNormal
static CNClass CNLogNormal_desc("CNLogNormal", "$Revision: 0.30 $",
			    CNLogNormal::new_object);

// "Type" for type checking functions
CNClassDesc CN_LOGNORMAL = &CNLogNormal_desc;






