//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: MLCG.h,v 0.30 1996-08-07 18:01:39+02 steppler Exp $
 *
 * CNClass: CNMLCG --- Multiple linear congruence generator
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#ifndef __MLCG_h
#define __MLCG_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/RNG.h>		// Base class

extern CNClassDesc CN_MLCG;	// CNClass CNMLCG description


/*
 * The class CNMLCG
 */

class CNMLCG : public CNRNG
{
public:
    virtual unsigned long as_long32();
    virtual void reset();
    virtual bool has_long32() {return FALSE;}
    virtual void seed(unsigned long s);

    void seed_internal(unsigned long, unsigned long);

    // Private members
private:
    unsigned long initialSeedOne;
    unsigned long initialSeedTwo;
    long seedOne;
    long seedTwo;

    /***** Constructors ******************************************************/
public:
    CNMLCG(); 		           		// Default constructor
    CNMLCG(CNParam *param); 			// CNParam constructor
    CNMLCG(long seed1, long seed2);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_MLCG;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_MLCG ? TRUE : CNRNG::is_a(desc);
    };
        
    static CNMLCG *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNMLCG *)obj;
#   else
	return (CNMLCG *)( !obj || obj->is_a(CN_MLCG)
	       ? obj : fatal_type(obj->class_desc(), CN_MLCG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNMLCG(param) : new CNMLCG; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__MLCG_h**/
