//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Rayleigh.h,v 0.30 1996-08-07 18:02:05+02 steppler Exp $
 *
 * CNClass: CNRayleigh --- CNRayleigh distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Rayleigh_h
#define __Rayleigh_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Normal.h>		// Base class

extern CNClassDesc CN_RAYLEIGH;	// CNClass CNRayleigh description



/*
 * The class CNRayleigh
 */

class CNRayleigh : public CNNormal
{
public:
    virtual double operator()();

    /***** Constructors ******************************************************/
public:
    CNRayleigh();  				// Default constructor
    CNRayleigh(CNParam *param);			// CNParam constructor
    CNRayleigh(double variance, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_RAYLEIGH;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_RAYLEIGH ? TRUE : CNNormal::is_a(desc);
    };
        
    static CNRayleigh *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNRayleigh *)obj;
#   else
	return (CNRayleigh *)( !obj || obj->is_a(CN_RAYLEIGH)
	       ? obj : fatal_type(obj->class_desc(), CN_RAYLEIGH) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNRayleigh(param) : new CNRayleigh; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__Rayleigh_h**/
