//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Confidence.h,v 1.2 1996-08-07 18:02:50+02 steppler Exp $
 *
 * CNClass: CNConfidence --- Simple stat. evaluation: mean, variance,
 * 			     skewness etc.
 *
 * Derived from SIC - Simulation In C++
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Confidence_h
#define __Confidence_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Statistics.h>		// Base class
#include <CNCL/String.h>

extern CNClassDesc CN_CONFIDENCE;	// CNClass CNConfidence description

/*
 * The class CNConfidence
 */

class CNConfidence : public CNStatistics {
  public:
    virtual void put(double x_i);
    virtual double mean() const;
    virtual void reset();
    double variance() const;
    double M_2() const;
    double M_3() const;
    double Z_3() const;
    double relative_variance() const;
    double deviation() const;
    double relative_deviation() const;
    double skewness() const;
    double z_level(double) const;
    double conf_level(double ) const;
    double err_level(double ) const;
    double low_conf_bound(double ) const;
    double hi_conf_bound(double ) const;
    
    virtual unsigned long   trials() const { return n; }
    virtual double max()    const { return max_value; }
    virtual double min()    const { return min_value; }

    virtual bool   end()    const { return FALSE; }
    virtual Phase  state()  const { return ITERATE; }
    virtual Phase  status() const { return ITERATE; }

    // Private members
  private:
    CNString name;	// Name
    double sum ;	// Sum of all values
    double sqsum ;	// Sum of all values^2
    double cbsum ;	// Sum of all values^3
    long   n;		// # of values
    double min_value;	// Minimum of all values
    double max_value;	// Maximum of all values

    typedef struct ez_level{double z,conf; } s_ezl;
    static struct ez_level level[];


    /***** Constructors ******************************************************/
  public:
    CNConfidence(const char* aName = NIL,
	      const char* aDescription = NIL);
    CNConfidence(CNParam *) {}			// CNParam constructor
    
    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_CONFIDENCE;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_CONFIDENCE ? TRUE : CNStatistics::is_a(desc);
    };
        
    static CNConfidence *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNConfidence *)obj;
#   else
	return (CNConfidence *)( obj->is_a(CN_CONFIDENCE)
					? obj : fatal_type(obj->class_desc(), CN_CONFIDENCE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNConfidence(param) : new CNConfidence; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__Confidence_h**/
