//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_                C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                          N E T W O R K S
 * |_        |_  |_  |_  |_        |_                                C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                      L I B R A R Y
 *
 * $Id: DLREF.h,v 0.33 1996-08-07 18:02:56+02 steppler Exp $
 *
 * Class: CNDLREF --- Discrete LRE (LRE III) for distribution function
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __DLREF_h
#define __DLREF_h


#include <CNCL/DLRE.h>


extern CNClassDesc CN_DLREF;      // CNClass CNDLREF description

/*
 * The class CNDLREF
 */

class CNDLREF : public CNDLRE 
{
  
    /***** Constructors ******************************************************/
public:
    CNDLREF(double*, long, double, double = 0.0, 
	    const char* = NIL, const char* = NIL,
	    double = 0.0, unsigned long = ULONG_MAX);
    CNDLREF(double, double, double, double, double = 0.0, 
	    const char* = NIL, const char* = NIL, 
	    double = 0.0, unsigned long = ULONG_MAX); 
    CNDLREF(CNParam *) {}  // CNParam constructor
    ~CNDLREF() {}
  
private:
    CNDLREF() {}
  
public: 
    void put( double );
  
    virtual double cur_f_lev();    // returns current f-level
    virtual double f( double );    // returns the f-level of parameter 
    
    virtual const CNDLRE::resultline *get_result( long ); // result line

    virtual void change_error( double );
    
private:
    Phase rtc(); // runtime control

    double Fmin;

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const      // CNClass description
    {
	return CN_DLREF;
    };
  
    virtual bool is_a(CNClassDesc desc) const   // Type checking
    {
	return desc == CN_DLREF ? TRUE : CNDLRE::is_a(desc);
    };
        
    static CNDLREF *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDLREF *)obj;
#   else
        return (CNDLREF *)( obj->is_a(CN_DLREF)
			    ? obj : fatal_type(obj->class_desc(), CN_DLREF) );
#   endif
    }
  
    // Print/debug output
    virtual void print( ostream &output=cout ) const; 
};

#endif
