//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_                C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                          N E T W O R K S
 * |_        |_  |_  |_  |_        |_                                C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                      L I B R A R Y
 *
 * $Id: LREG.c,v 0.32 1996-08-07 18:03:13+02 steppler Exp $
 *
 * Class: CNLREG --- LRE evaluation G(x) (compl. distribution function)
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "LREG.h"



void CNLREG::put (double rvnach)
{

/************************************************************************/
/* Deklaration der internen Variablen                                   */
/************************************************************************/

    result *presult;                 /* Hilfszeiger Ergebnistabelle  */
    result *start,*end;              /* Hilfszeiger Transcountkorretur*/
    int step;                        /* Hilfe Transcountkorretur     */

    nrv ++;
    CNLRE::rv_sum        += rvnach;
    CNLRE::rv_square_sum += rvnach * rvnach;
    if (CNLRE::max_value < rvnach) CNLRE::max_value = rvnach; 
    else if (CNLRE::min_value > rvnach) CNLRE::min_value = rvnach;
    // 03.12.93 (fuss)

    if (rvakt <= pr->xlevlim )      /* values lower equal than the current  */
    {                               /* level are not sorted                 */
        verbesser(pfirst,pr,rvakt,rvnach); /* nachbessern der Level */
    }
    else
    {
        pr->sortmsize++;
        if (rvnach < pr->xlevlim) /* save transition                    */
	{
	    //printf("transcount\n");
	    pr->transcount++;
	    start = pfirst;
	    end = pr;
	    while ( (step = (end - start) >> 1) )
	    {
		presult = start + step ;
		if ( presult->xlevlim > rvnach)
		    end = presult;
		else
		    start = presult;
	    }
	    start->transcount--; /* ab da gibt es keine Uebergange mehr */
	}

        /* save the values      */

        sortquickend->rvakt = rvakt;
        sortquickend->rvnach = rvnach;
        sortquickend++;

        if ( pr->sortmsize >= sortfeldgroesse)
	    schaufelum();
    }

    /* nur wenn gegisste Anzahl der benoetigten Werte */
    if ( nrv >= ((unsigned long)n0))
    {
        //printf("go to next level (%f) \n", pr->xlevlim);
        next_level();
    }
    rvakt = rvnach;
}

void CNLREG::neusort(result *presult)
{
    sm *end;
    sm *dest;
    double neurvakt;

/* sort the sort array   */
    
/* sort the new valuues        */

    if ((sortquickend - sortquick) > 1)
        quicksort(sortquick,sortquickend-1);

/* Sortierte Werte mit den anderen schon sortierten Werten mischen */

    dest = new sm[pr->sortmsize + 2];
    end = mergesort(dest);
    
/* delete old list      */
    
    delete sortmerge;
    sortmerge = dest;
    
/*************************************************************/
/* fehlende Werte in presult besetzen                        */
/*************************************************************/

    if ( end == dest) /* empty sort-array */
    {
        phase = END;
        return;
    }
    
/*****************************************************************/
/* Beim ersten Wert so tun als waere er der gerade kleinste Wert */
/*****************************************************************/

    if ( pr->xlevlim == -DBL_MAX)
    {
        while ( (end-1)->rvakt == (end - pr->nxvalue -1)->rvakt) pr->nxvalue++;
//      pr->xlevlim = (end-1)->rvakt;
//      echoresult( pr, nrv );
    }
    
/*************************************/
/* search new level                  */
/*************************************/
    
    if ( (end - dest) <= presult->sortmsize )
    {                       /* neues xlevel */
	neurvakt = (end-1)->rvakt;
    }
    else 
    {
	neurvakt = ( dest + presult->sortmsize)->rvakt;
	if ( neurvakt == pr->xlevlim
	     || neurvakt == (end-1)->rvakt && pr->xlevlim == -DBL_MAX )
	    neurvakt = ( end - pr->nxvalue - 1 )->rvakt;
    }
    
    presult->xlevlim = neurvakt;
    end->rvakt = neurvakt + 1.0; // ist jetzt immmer ungleich rvakt;
    
    while(dest->rvakt > neurvakt)
    {
        if (dest->rvnach < neurvakt)
	    presult->transcount++;
        dest++;
    }
    sortmergeend = dest;
    
    while (dest->rvakt == neurvakt)
    {
        if (dest->rvnach < neurvakt)
	    presult->transcount++;
        presult->nxvalue++;
        dest++;
    }
    
    presult->sortmsize = dest - sortmerge ;
    
/*************************************************************/
/* Sortierfeld Erneuern                                      */
/*************************************************************/

    sortquickend = sortquick;
}

CNLRE::sm *CNLREG::mergesort(sm *dest)
{
    sm *source1 = sortquick;
    sm *end1 = sortquickend;
    sm *source2 = sortmerge;
    sm *end2 = sortmergeend;

    if (source1 != end1 && source2 != end2)
    { /* keines der Felder leer */
        while (1)
	{       /* aus beiden Quellen mischen */
	    if (source1->rvakt >= source2->rvakt)
	    {
		*dest++ = *source1++ ;
		if (source1 == end1) break ;
	    }
	    else
	    {
		*dest++ = *source2++ ;
		if (source2 == end2) break ;
	    }
	}
    }
    

    if (source1 == end1 )
    {                       /* source 1 empty */
        while(source2 < end2 )
	    *dest++ = *source2++ ;
    }
    else
    {                       /* source 2 empty */
	while(source1 < end1 )
	    *dest++ = *source1++ ;
    }
    return(dest);
}

void CNLREG::quicksort( sm *first, sm *last)
{
    sm *left = first-1 ;
    sm *right = last+1 ;
    double ref = first->rvakt;
    sm temp ;

    while (left < right)
    {
	while ((++left)->rvakt > ref);
	while ((--right)->rvakt < ref);
	if (left < right)
	{
	    temp = *left;
	    *left = *right;
	    *right = temp;
	}
    }
    left--;
    right++;
    if (first < left) quicksort(first, left) ;
    if (right < last) quicksort(right, last) ;
}
/***********************************************************************/
/*  die Funktion sortiert die Werte in das Ergebnisfeld ein.           */
/*  Das Ergebnisfeld ist differentiell abgelegt.                       */
/*                                                                     */
/*                                                                     */
/***********************************************************************/

void CNLREG::verbesser( result *pfirst, result *pr,
			double rvakt,double rvnach)
{
    
    result *start = pfirst;
    result *end = pr;
    result *presult;
    int step;

//printf("Verbesser: %f   %f   %f   %f   %f\n", pfirst->xlevlim, pr->xlevlim,
//      rvakt,rvnach);

    while( (step = end - start) > 1)
    {
        presult = start + (step >> 1);
        if ( presult->xlevlim >= rvakt)
	    end = presult;
	else
	    start = presult;
    }

    if (end->xlevlim == rvakt)
	end->nxvalue++;
    else
	end--;
    end->sortmsize++;

    if (rvnach < end->xlevlim)
    {
        end->transcount++;
        start = pfirst;
        while( (step = end - start) > 1)
	{
	    presult = start + (step >> 1);
	    if ( presult->xlevlim > rvnach)
		end = presult;
	    else
		start = presult;
	}
        start->transcount--;
    }
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNLREG
static CNClass CNLREG_desc("CNLREG", "$Revision: 0.32 $",
                           CNLREG::new_object);

// "Type" for type checking functions
CNClassDesc CN_LREG = &CNLREG_desc;
