#include <CNCL/Batches.h>
#include <CNCL/BatchMeans.h>

#include <CNCL/Moments.h>

#include <CNCL/FiboG.h>
#include <CNCL/NegExp.h>
#include <CNCL/Uniform.h>
#include <CNCL/RndInt.h>


int main()
{
    CNFiboG   base;
    CNNegExp  neg(0.5, &base);
    CNUniform uni(1.0, 5.0, &base);
    //CNRndInt uni(1, 5, &base);
    
    cout << "size of base, neg, uni: " << sizeof(base) << ", "
	 << sizeof(neg) << ", " << sizeof(uni) << endl;
    
    CNMoments mom_neg("mom_neg");
    CNMoments mom_uni("mom_uni");

    CNBatches bat_neg(0.0, 5.0, 0.02, 10, 1000, 10, 99, "bat_neg");
    CNBatches bat_uni(1.0, 5.0, 0.02, 10, 1000, 8, 99, "bat_uni");

    CNBatchMeans btm_neg(0.0, 5.0, 10l, 1000l, 10l, 99, "btm_neg");
    CNBatchMeans btm_uni(1.0, 5.0, 8l, 1000l, 0.005, 99, "btm_uni");

    cout << "sizeof mom_neg, bat_neg, btm_neg: " << sizeof(mom_neg)
	 << ", " << sizeof(bat_neg) << ", " << sizeof(btm_neg) << endl;

    bool out_flag = true;
    for (;;)
    {
	double x = neg();
	mom_neg.put(x);
	bat_neg.put(x);
	btm_neg.put(x);

	double y = uni();
	mom_uni.put(y);
	bat_uni.put(y);
	btm_uni.put(y);

	if (btm_uni.end()) break; // all are ready by then
	if (btm_uni.groups_done() == 5 && out_flag)
	{
	    cout << "btm_uni: p(3)=" << btm_uni.p(3) << " f(3)="
		 << btm_uni.f(3) << " g(3)=" << btm_uni.g(3) << endl;
	    cout << "btm_uni: trials=" << btm_uni.trials() << " min="
		 << btm_uni.min() << " max=" << btm_uni.max() << endl;
	    cout << "btm_uni: mean=" << btm_uni.mean() << " bayes_err="
		 << btm_uni.bayes_err() << " confidence="
		 << btm_uni.mean_confidence() << endl;
	    cout << "btm_uni: variance=" << btm_uni.variance()
		 << " sigma=" << btm_uni.sigma() << " correlation="
		 << btm_uni.correlation() << endl;
	    cout << "btm_uni: min_index=" << btm_uni.min_index()
		 << " max_index=" << btm_uni.max_index() << endl;
	    out_flag = false;
	}
	if (btm_uni.groups_done() == 8 && !out_flag)
	{
	    const CNBatchMeans::resultline* out;
	    cout << "\nbtm_uni::output" << endl
		 << "x    /f(x)/ferr(x)/fconf(x)" << endl;
	    cout << "rh(x)/g(x)/gerr(x)/gconf(x)" << endl;
	    for (long i = btm_uni.min_index();
		 i <= btm_uni.max_index(); i++)
	    {
		out = btm_uni.get_result(i);
		cout << out->x << " " << out->fx << " " << out->ferr
		     << " " << out->fconf << endl;
		cout << out->rh << " " << out->gx << " " << out->gerr
		     << " " << out->gconf << endl;
	    }
	    out_flag = true;
	}
    }
    
    cout << endl << mom_neg << endl << bat_neg << endl << btm_neg << endl;
    cout << endl << mom_uni << endl << bat_uni << endl << btm_uni << endl;
    
    return 0;
}
