// -*- C++ -*-

#include <CNCL/ACG.h>
#include <CNCL/Uniform.h>
#include <CNCL/RndInt.h>
#include <CNCL/DLREF.h>
#include <CNCL/DLREG.h>
#include <CNCL/DLREP.h>


main()
{
    CNRNG    * rng = new CNACG;
    CNUniform  zg(0, 1, rng);
    double   * x   = new double[2];
    x[0] = -1; x[1] = 1;
    double     z   = 0.0;

    // probability function
    // all possible x-values (here: 2) are stored in one array
    CNDLREP    dlrep1(x, 2, 0.05);

    while( !dlrep1.end() )
    {
        z = zg();
        //cout << z << " ";
        if( z <= 0.5 )
        {
            dlrep1.put( -1 );
        }
        else
        {
            dlrep1.put( 1 );
        }
    }

    cout << dlrep1 << endl;
    delete x;
    
    // complementary distribution function
    // Now the lower (1.0) and the upper limit (100.0) and the
    // interval width are specified
    CNDLREG   dlreg2(1.0, 100.0, 1.0, 0.05);

    CNUniform zg2(1, 100, rng);
    
    while( !dlreg2.end() )
    {
        z = zg2();
        dlreg2.put( z );
    }

    cout << dlreg2 << endl;
    
    // distribution function
    // Now test use of non equidistant x-values
    double y[] = { 1.0, 2.0, 4.0, 5.0, 8.0, 11.0, 20.0 };
   
    CNDLREF dlref3(y, 7, 0.02, 1.0);

    CNRndInt zg3(1, 20, rng);
    long n;

    while (!(dlref3.end()))
    {
	n = zg3();
	switch (n)
	{
	  case 1: 
	    dlref3.put( 1.0 );
	    break;
	  case 2:
	    dlref3.put( 2.0 );
	    break;	    	      
	  case 4:
	    dlref3.put( 4.0 );
	    break;	    
	  case 5:
	    dlref3.put( 5.0 );
	    break;
	  case 8:
	    dlref3.put( 8.0 );
	    break;	    
	  case 11:
	    dlref3.put( 11.0 );
	    break;
	  case 20:
	    dlref3.put( 20.0 );
	    break;
	  default:
	    break;
	}
    }
    
    cout << dlref3 << endl;

    // test get_result
    cout << endl;
    const struct CNDLRE::resultline *p;
    for (long l = dlref3.min_index(); l <= dlref3.max_index(); l++)
    {
	p = dlref3.get_result( l );
	cout << p->vf << "  " << p->x << "  " << p->relerr << "  "
	  << p->rho << "  " << p->sigrho << " " << p->nx << endl;
    }

    delete rng;
}
