// Messages mechanism : allow object to send and receive messages

#ifndef MESSAGES_H
#define MESSAGES_H

#include "lge.h"

// Targeted messages
#define LISTBOX_REDRAW		0x0100
#define LISTBOX_SELECT		0x0101
#define SCROLLBAR_SETPOSITION	0x0200
#define CHECKBOX_SETSTATE	0x0300
#define RADIOBUTTON_SETSTATE	0x0500
#define STATIC_SETCOLOR		0x0600

#define OBJECT_ACTIVATE		0x0000
#define OBJECT_DESACTIVATE	0x0001

// Diffused messages
#define LISTBOX_NEWSELECTION	0x0170
#define SCROLLBAR_NEWPOSITION	0x0270
#define CHECKBOX_NEWSTATE	0x0370
#define PUSHBUTTON_PRESSED	0x0470
#define RADIOBUTTON_ACTIVATED	0x0570
#define MENU_SELECTED		0x0670

typedef struct MSG {
  int	  ID;
  PObject CallBack;
  MSG	  *Next;
};
typedef MSG *PMSG;

extern PMSG MsgList;
extern int  CurrentHnd;

#define msg_OK		0
#define msg_BADID	1
#define msg_NOSUCHID	2
#define msg_NOMORESLOTS	-1

int  AllocRessource();
int  RegisterMessage(int id, PObject obj);
int  KillMessage(int id);
int  SendMessage(int src, int id, int msg, long param1, long param2);
void DiffMessage(int src, int msg, long param1, long param2);

#endif
