//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#include <herror.hxx>
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>
#include <stdlib.h>


////////////////////////////////////////////////////////////////////
// externe variabelen.
////////////////////////////////////////////////////////////////////

char HERROR_MSG[HERROR_MSG_LEN],HERROR_MSG_I[HERROR_MSG_LEN]; 

////////////////////////////////////////////////////////////////////
// Statische variabelen
////////////////////////////////////////////////////////////////////

static checkp_out *output=NULL;
static checkpoint *top=NULL;

static char *version=_VERSION_;

////////////////////////////////////////////////////////////////////
// static functions.
////////////////////////////////////////////////////////////////////

static void checkpoints_output(void);

////////////////////////////////////////////////////////////////////
// checkpoint class
////////////////////////////////////////////////////////////////////

checkpoint::checkpoint(const char *fil,const int lin,const char *func)
{
  next=top;
  top=this;
  file=(char *) fil;
  line=(int ) lin;
  function=(char *) func;
  if (output==NULL) {
    output=new checkp_out;
    if (output==NULL) {
      THROW_FATAL("Can't allocate memory for checkp_out class");
    }
  }
}

checkpoint::~checkpoint()
{
  top=next;
}

void checkpoints_output(void) 
{
  if (top!=NULL) {
    top->print();
  }
}

void checkpoint::print(void)
{
static char msg[HERROR_MSG_LEN];
static checkpoint *p=top;
  while (p!=NULL) {
    if (output!=NULL) {
      output->print("  in %s() at line %d (file=%s)",function,line,file);
    }
    else {
      fprintf(stderr,"  in %s() at line %d (file=%s)",function,line,file);
    }
    p=p->next;
  }
}


////////////////////////////////////////////////////////////////////
// checkp_out class
////////////////////////////////////////////////////////////////////

void checkp_out::print(char *format,...)
{
static char    msg[HERROR_MSG_LEN];
static va_list arg;

   va_start(arg,format);
   vsprintf(msg,format,arg);
   va_end(arg);
   fprintf(stderr,"%s\n",msg);
}

////////////////////////////////////////////////////////////////////
// herror handle functions
////////////////////////////////////////////////////////////////////

void herror_checkpoints(char ind,int exitcode)
{
  if (ind=='F') {
    checkpoints_output();
  }
  else if (ind=='E' && exitcode!=0) {
    checkpoints_output();
  }
}

void herror_handle(char *msg)
//
// formaat msg: I[num]:.....
//  I=F - fatal error
//  I=W - warning
//  I=E - error
//  num (optional) exit code. Voor F mandatory
//
{
char c=toupper(msg[0]);
int  e;
  output->print("herror %s",version);
  switch(c) {
    case 'F' : 
               e=atoi(&msg[1]);
               output->print("fatal: %s",msg);
               checkpoints_output();
               if (e==HERROR_NONE) { e=HERROR_FATAL; }
               exit(e);
    break;
    case 'E' : 
               e=atoi(&msg[1]);
               output->print("error: %s",msg);
               checkpoints_output();
               if (e!=HERROR_NONE) { exit(e); }
    break;
    default:   
               e=atoi(&msg[1]);
               output->print("warning: %s",msg);
               if (e>HERROR_WARN) {
                 checkpoints_output();
                 exit(e);
               }

  } 
}


