//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#include <hini.hxx>
#include <hregex.hxx>
#include <stdlib.h>
#include <ctype.h>

#ifdef WIN32
#define stricmp _stricmp
#define __FUNCTION__ "win32"
#else
#define stricmp strcasecmp
#endif

hini::hini(char *filename,bool mustExist)
{
FILE *f;
char line0[MAX_INI_LINE_LEN+2],*line=line0+1;
int  lines=0;

  CHECKPOINT;

  written=false;

  _name=filename;
  f=fopen(_name.c_str(),"rt");

  if (f!=NULL) {
    sections[sections.len()]=0;
    while(fgets(line,MAX_INI_LINE_LEN,f)!=NULL) {
      if (line[strlen(line)-1]=='\n') {
        line[strlen(line)-1]='\0';
      }
      entries[lines]=line;

      if (isSection(lines)) { sections[sections.len()]=lines;ids[lines]=0; }
      else if (isEntry(lines)) { ids[lines]=mkId(lines); }
      else { ids[lines]=0; }

      lines+=1;
    }
    fclose(f);
  }
  else {
    if (mustExist) {
      THROW_FATAL2(".INI file '%s' bestaat niet",_name.c_str());
    }
  }

  _emptyfile=(entries.len()==0);
}

hini::~hini()
{
  CHECKPOINT;
  if (written) {FILE *f;
    f=fopen(_name.c_str(),"wt");
    if (f==NULL) {
      THROW_FATAL2("Kan .ini file '%s' niet openen om te schrijven",
                   _name.c_str()
                  );
    }
    else {int i,N;
      for(i=0,N=entries.len();i<N;i++) {
        fprintf(f,"%s\n",entries[i].c_str());
      }
      fclose(f);
    }
  }
}

bool hini::read(char *section,char *_id,string & value,int index)
{
int i,N;
string id=_id;
int id_id;
char *__id;

  CHECKPOINT;

  value="";

  if (index>=0) {char num[10];
    sprintf(num,"[%d]",index);
    id=id+num;
  }
  __id=(char *) id.c_str();
  id_id=mkId(__id);

  for(i=0,N=sections.len();i<N && !rightSection(sections[i],section);i++);
  //for(i=0,N=entries.len();i<N && !rightSection(i,section);i++);

  if (i<N) {
    i=sections[i];	// move to the right section
    N=entries.len();    // make N the right length now

    if (strcmp(section,"")==0) { i-=1; }

    do {
      for(i+=1;i<N && !isSection(i) && id_id!=ids[i];i++);
    } while (i<N && !isSection(i) && !rightEntry(i,__id));

    if (i<N && !isSection(i)) {
      getValue(i,value);
      return true;
    }
  }

return false;
}

bool hini::read(char *section,char *id,int & value,int index)
{
string r;

  CHECKPOINT;

  if (read(section,id,r,index)) {char *p,*rc=(char *) r.c_str();
    value=(int) strtol(rc,&p,10);
    if (p==rc) {
      return false;
    }
    else {
      return true;
    }
  }
  else {
    value=0;
    return false;
  }
}

bool hini::read(char *section,char *id,double & value,int index)
{
string r;

  CHECKPOINT;

  if (read(section,id,r,index)) {char *p,*rc=(char *) r.c_str();
    value=strtod(rc,&p);
    if (p==rc) {
      return false;
    }
    else {
      return true;
    }
  }
  else {
    value=0.0;
    return false;
  }
}

bool hini::write(char *section,char *_id,string & value,int index)
{
int i,N;
string sec,l,id=_id;
char *__id;
int id_id;

  CHECKPOINT;

  if (index>=0) {char num[10];
    sprintf(num,"[%d]",index);
    id=id+num;
  }
  __id=(char *) id.c_str();
  id_id=mkId(__id);

  for(i=0,N=entries.len();i<N && !rightSection(i,section);i++);
  if (i<N) {
    for(i+=1;i<N && !isSection(i) && !rightEntry(i,__id);i++);

    l  =id+"="+value;

    if (rightEntry(i,__id)) { 
      entries[i]=l; 
    }
    else { int k,N;
      for(k=0,N=sections.len();k<N;k++) {
        if (sections[k]>=i) { sections[k]+=1; }
      }
      entries.insert(i,l); 
      ids.insert(i,id_id);
    }
  }
  else {
    l  =id+"="+value;
    sec="[";sec=sec+section+"]";
    entries[i]=sec;
    entries[i+1]=l;
    ids[i]=0;
    ids[i+1]=id_id;
    sections[sections.len()]=i;
  }

  written=true;

return true;
}

bool hini::write(char * section,char * id,int value,int index)
{
char num[100];
string v;

  CHECKPOINT;

  sprintf(num,"%d",value);
  v=num;
return write(section,id,v,index);
}

bool hini::write(char * section,char * id,double value,int index)
{
char num[100];
string v;

  CHECKPOINT;

  sprintf(num,"%lf",value);
  v=num;
return write(section,id,v,index);
}

bool hini::write(char * section,char * id,char *value,int index)
{
string v;

  CHECKPOINT;

  v=value;
return write(section,id,v,index);
}

////////////////////////////////////////////////////////////////////
//
// Private functions
//
////////////////////////////////////////////////////////////////////

bool hini::rightSection(int line,char * section)
{
  if (strcmp(section,"")==0) {
    return true;
  }
  else {
    string sec="[";
    string l;
      sec=sec+section+"]";
      CHECKPOINT;
      Trim(l,entries[line]);
    return stricmp(l.c_str(),sec.c_str())==0;
  }
}

bool hini::isSection(int line)
{
string l;

  CHECKPOINT;

  Trim(l,entries[line]);
return (l[0]=='[' && l[l.length()-1]==']');
}

bool hini::rightEntry(int line,char *id)
{
string l;
int    i,N;
string & s=entries[line];
  CHECKPOINT;

  for(i=0,N=s.length();i<N && s[i]!='=';i++);
  if (i==N) {
    return false;
  }
  else {
    Take(l,s,i);
    Trim(l,l);
    return stricmp(l.c_str(),id)==0;
  }
}

bool hini::isEntry(int line)
{
int    i,N;
string & s=entries[line];
  for(i=0,N=s.length();i<N && s[i]=='\t' && s[i]==' ';i++);
  if (i!=N && s[i]!=';') { 
    for(i=0,N=s.length();i<N && s[i]!='=';i++);
    return i!=N;
  }
  else {
    return false;
  }
}

string & hini::getEntry(int line)
{
int    i,N;
string & s=entries[line];
  for(i=0,N=s.length();i<N && s[i]!='=';i++);
  if (i==N) {
    _entry="";
    return _entry;
  }
  else {
    Take(_entry,s,i);
    Trim(_entry,_entry);
    return _entry;
  }
}

int hini::mkId(char *id)
{
int n,i,N;
  for(i=0,N=strlen(id);i<N;i++) {
    n=n+toupper(id[i]);
    n<<=1;
  }
return (n==0) ? 1 : 0;
}

int hini::mkId(int line)
{
string id=getEntry(line);
return mkId((char *) id.c_str());
}

void hini::getValue(int line,string & r)
{
string l,& s=entries[line];
int i,N;

  CHECKPOINT;

  for(i=0,N=s.length();i<N && s[i]!='=';i++);
  if (i==N) {
    THROW_FATAL("'=' teken niet gevonden, onverwacht");
  }
  else {
    Drop(l,s,i+1);
    Trim(r,l);
  }
}

void hini::getSection(int line,string & r)
{
  Trim(r,entries[line]);
  Drop(r,r,1);
  Take(r,r,r.length()-1);
}

string & hini::section(int i)
{
  if (i==0) { _section="";_lastline=0; }
  else { getSection(sections[i],_section);_lastline=sections[i]+1; }
return _section;
}

string & hini::nextIdIsEntry(void)
{
  while (_lastline<entries.length() && !isSection(_lastline) && 
         !isEntry(_lastline)
        ) {
     _lastline+=1;
  }
  if (_lastline==entries.length() || isSection(_lastline)) {
    _idIsEntry="";
  }
  else {
    _idIsEntry=entries[_lastline];
    _lastline+=1;
  }
return _idIsEntry;
}

bool hini::sectionExists(string sec)
{
int i,N;
char *_sec=(char *) sec.c_str();
  for(i=0,N=sections.len();i<N && !rightSection(sections[i],_sec);i++);
return (i!=N);
}

