//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#include <hmmap.hxx>
#include <herror.hxx>

#ifndef WIN32
  #include <sys/mman.h>
  #include <unistd.h>
#else
  #include <winbase.h>
  #include <io.h>
  #include <fcntl.h>
#endif

void hmmap::construct(const char *filename)
{
  if (_readonly) {
    f=fopen(filename,"rb");
  }
  else {
    f=fopen(filename,"r+b");
  }
  if (f==NULL) {
    THROW_FATAL2("Can't open '%s'",filename);
  }
  fh=fileno(f);
  construct(fh);
}

void hmmap::construct(int fh)
{
#ifndef WIN32
  int flag;
  _filelen=lseek(fh,0,SEEK_END);

  if (_readonly) { flag=PROT_READ; }
  else { flag=PROT_READ|PROT_WRITE; }

  _mem=(char *) mmap(0,_filelen,flag,MAP_PRIVATE|MAP_FILE|MAP_VARIABLE,fh,0);

  extra=NULL;
#else
// add read write
  DWORD flag;
  if (_readonly) { flag=PAGE_READONLY; }
  else { flag=PAGE_READWRITE; }

  HANDLE h=CreateFileMapping((HANDLE) fh,NULL,flag,0,0,NULL);
  _mem=(char *) MapViewOfFile(h,FILE_MAP_READ,0,0,0);

  HANDLE *e=new HANDLE;
  e[0]=h;
  extra=(void *) e;
#endif
}

void hmmap::destruct(void)
{
#ifndef WIN32
  munmap(_mem,_filelen);
#else
  HANDLE *e=(HANDLE *) extra,h=e[0];
  UnmapViewOfFile(mem);
  CloseHandle(h);
  delete e;
#endif
}

hmmap::hmmap(const char *name,bool rdonly)
{
  f=NULL;fh=-1;_readonly=rdonly;
  construct(name);
}

hmmap::hmmap(const string & name,bool rdonly)
{
  f=NULL;fh=-1;_readonly=rdonly;
  construct(name.c_str());
}

hmmap::hmmap(int _fh,bool rdonly)
{
  f=NULL;fh=-1;_readonly=rdonly;
  construct(_fh);
}

hmmap::hmmap(FILE *f,bool rdonly)
{
  f=NULL;fh=-1;_readonly=rdonly;
  construct(fileno(f));
}

hmmap::~hmmap()
{
  destruct();
}

