//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#ifndef __HMMAP__HXX
#define __HMMAP__HXX

#include <hstring.hxx>
#include <vc6.hxx>

class hmmap
{
  private:
    char *_mem;
    bool _readonly;
    long _filelen;
    FILE *f;
    int   fh;
    void *extra;
  private:
    void construct(const char *name);
    void construct(int fh);
    void destruct(void);
  public:
    hmmap(const char *file,bool readonly=true);
    hmmap(const string & file,bool readonly=true);
    hmmap(FILE *f,bool readonly=true);
    hmmap(int fh,bool readonly=true);
   ~hmmap();
  public:
    char *mem(void)    { return _mem; }
    char *memory(void) { return _mem; }
};

#endif

