#include <qlayout.h>
#include <qlabel.h>

#include "TEditConnectionDlg.h"

TEditConnectionDlg::TEditConnectionDlg(TSignalSlot* ss, QWidget *parent, const char *name, bool modal): QDialog(parent, name, modal) {
  initMetaObject();

  fType = ctSignal;

  setCaption("Mawc Connection Editor");

  // Create Type button group and populate.
  bgroup = new TButtonGroup("Type", this, "Button Group");
  connect(bgroup, SIGNAL(clicked(int)), SLOT(groupClicked(int)));
  bgroup->setExclusive(TRUE);
  bgroup->insert("Signal");
  bgroup->insert("Slot");
  bgroup->setMinimumSize(bgroup->sizeHint());
  cout << "Set MinimumSize = " << bgroup->minimumSize().width() << ", " 
       << bgroup->minimumSize().height() << endl;

  // Create Privacy button group and populate
  bgroupPrivacy = new TButtonGroup("Privacy", this, "Privacy Group");
  connect(bgroupPrivacy, SIGNAL(clicked(int)), SLOT(privacyClicked(int)));
  bgroupPrivacy->setExclusive(TRUE);
  bgroupPrivacy->insert("Public");
  bgroupPrivacy->insert("Protected");
  bgroupPrivacy->insert("Private");
  bgroupPrivacy->setMinimumSize(bgroupPrivacy->sizeHint());
  
  cbVirtual = new QCheckBox("Virtual", this, "cb Virtual");
  cbVirtual->setFixedSize(cbVirtual->sizeHint());
  
  btnOK = new QPushButton("OK", this);
  connect(btnOK, SIGNAL(clicked()), SLOT(accept()));

  btnCancel = new QPushButton("Cancel", this);
  connect(btnCancel, SIGNAL(clicked()), SLOT(reject()));

  btnCancel->adjustSize();
  btnCancel->setFixedSize(btnCancel->size());
  btnOK->setFixedSize(btnCancel->size());

  editName = new QLineEdit(this);
  editName->setFixedHeight(editName->fontMetrics().height()+6);
  editArgs = new QLineEdit(this);
  editArgs->setFixedHeight(editName->fontMetrics().height()+6);

  QLabel *labelName = new QLabel("Name: ", this);
  QLabel *labelArgs = new QLabel("Arguments: ", this);
  labelArgs->adjustSize();
  labelArgs->setFixedSize(labelArgs->size());
  labelName->setFixedSize(labelArgs->size());


  // Lay everything out.
  QVBoxLayout *layout = new QVBoxLayout(this, 10, -1, "mainLayout");

  QHBoxLayout *toplayout = new QHBoxLayout(-1,  "TopLayout");
  layout->addLayout(toplayout);
  layout->addWidget(cbVirtual);

  QHBoxLayout *nameLayout = new QHBoxLayout(-1, "NameLayout");
  layout->addLayout(nameLayout);

  QHBoxLayout *argsLayout = new QHBoxLayout(-1, "ArgsLayout");
  layout->addLayout(argsLayout);
  
  QHBoxLayout *okCancel = new QHBoxLayout(-1, "OKCancel Layout");
  layout->addLayout(okCancel);
  

  // Populate all of the layouts we have just set up...
  toplayout->addWidget(bgroup, 1);
  toplayout->addWidget(bgroupPrivacy, 1);

  nameLayout->addWidget(labelName, 0);
  nameLayout->addWidget(editName, 0);

  argsLayout->addWidget(labelArgs, 1);
  argsLayout->addWidget(editArgs, 1);

  okCancel->addStretch(1);
  okCancel->addWidget(btnOK);
  okCancel->addSpacing(10);
  okCancel->addWidget(btnCancel);
  okCancel->addStretch(1);

  // Set up minimum size
  setMinimumSize(sizeHint());
  adjustSize();
  layout->activate();


  if (ss) {
    setName(ss->name);
    setArgs(ss->args);
    setType(ss->type);
    if (ss->type==ctSlot) {
      setVirtual( ((TSlot*)ss)->isVirtual );
      setPrivacy( ((TSlot*)ss)->privacy );
    }

    bgroup->setEnabled(FALSE);
    editName->setEnabled(FALSE);
  }
  else {
    setPrivacy(spPublic);
    setArgs("");
    setName("");
    setVirtual(FALSE);
    setType(ctSignal);
  }
}


QSize TEditConnectionDlg::sizeHint() const {
  QSize s(30 + editArgs->width() + 2*btnOK->width(),
	  bgroup->minimumSize().height() + 2*editName->height()
	  + btnOK->height() + 5*10);
  return s;
}




TConnectionType TEditConnectionDlg::type() {
  return fType;
}
void TEditConnectionDlg::setType(TConnectionType type) {
  fType = type;
  bgroup->setActive((int)type);

  if (ctSlot == type) {
    cout << "setting type to slot" << endl;
    bgroupPrivacy->setEnabled(TRUE);
    cbVirtual->setEnabled(TRUE);
  }
  else {
    cout << "setting type to signal" << endl;
    bgroupPrivacy->setEnabled(FALSE);
    cbVirtual->setEnabled(FALSE);
  }
}

QString TEditConnectionDlg::name() {
  return editName->text();
}
void TEditConnectionDlg::setName(QString s){
  editName->setText(s);
}


QString TEditConnectionDlg::args() {
  return editArgs->text();
}
void TEditConnectionDlg::setArgs(QString  s){
  editArgs->setText(s);
}


bool TEditConnectionDlg::isVirtual() {
  return cbVirtual->isChecked();
}
void TEditConnectionDlg::setVirtual(bool v) {
  cbVirtual->setChecked(v);
}


TSlotPrivacy TEditConnectionDlg::privacy() {
  return fPrivacy;
};

void TEditConnectionDlg::setPrivacy(TSlotPrivacy p) {
  if (privacy() != p) {
    fPrivacy = p;
    bgroupPrivacy->setActive((int)p);
  }
}


void TEditConnectionDlg::groupClicked(int id) {
  if (id==0)
    setType(ctSignal);
  else
    setType(ctSlot);
}

void TEditConnectionDlg::privacyClicked(int id) {
  setPrivacy((TSlotPrivacy)id);
  /*  switch (id) {
  case 0:
    setPrivacy(spPublic); break;
  case 1:
    setPrivacy(spProtected); break;
  case 2:
    setPrivacy(spPrivate); break;
  };*/
}
