#include <ostream.h>
#include <qdir.h>

#include "TFileInfo.h"



TFileInfo::TFileInfo():QFileInfo() {
	;
}

TFileInfo::TFileInfo(const char *file): QFileInfo(file) {
	;
}

TFileInfo::TFileInfo(const QFile &file): QFileInfo(file) {
	;
}

TFileInfo::TFileInfo(const QDir &dir, const char *file): QFileInfo(dir, file) {
	;
}

TFileInfo::TFileInfo(const TFileInfo &fi): QFileInfo(fi) {
	;
}


TFileInfo::~TFileInfo() {
	;
}


QString TFileInfo::relFilePath(const QDir &dir) {
	QString relDir = dir.absPath();
	QString fPath = absFilePath();
	
	relDir.append("/");
	int p = relDir.find('/');
	while (p!=-1) {
		if (0==strncmp(relDir, fPath, p)) {
			relDir = relDir.mid(p+1, strlen(relDir));
			fPath = fPath.mid(p+1, strlen(fPath));

			p = relDir.find('/');
		}
		else
			p=-1;
	}


	p = relDir.find('/');
	while (p!=-1) {
		fPath.prepend("../");
		p = relDir.find('/', p+1);
	}

	return fPath;
}
