#include <iostream.h>
#include "THandle.h"

const int CHandleOffset = 4;
const int CHandleSize = 2*CHandleOffset;

THandle::THandle(THandlePosition hpos, QWidget *parent, const char *name): QWidget(parent, name){
  initMetaObject();
  setBackgroundColor(yellow);
  hPosition = hpos;

  switch (hpos) {
  case NW:
    setCursor(sizeFDiagCursor);
    break;
  case N:
    setCursor(sizeVerCursor);
    break;
  case NE:
    setCursor(sizeBDiagCursor);
    break;
  case E:
    setCursor(sizeHorCursor);
    break;
  case SE:
    setCursor(sizeFDiagCursor);
    break;
  case S:
    setCursor(SizeVerCursor);
    break;
  case SW:
    setCursor(sizeBDiagCursor);
    break;
  case W:
    setCursor(sizeHorCursor);
    break;
  }
}





void THandle::setPositionRect(QObject*,const QRect &rect) {
  rectangle = rect;
  switch (handlePosition()) {
  case NW:
    move(rect.left(), rect.top()); break;
  case N:
    move(rect.left()+int(rect.width()/2)-CHandleOffset, rect.top()); break;
  case NE:
    move(rect.right()-CHandleSize, rect.top()); break;
  case E:
    move(rect.right()-CHandleSize, rect.top()+int(rect.height()/2)-CHandleOffset); break;
  case SE:
    move(rect.right()-CHandleSize, rect.bottom()-CHandleSize); break;
  case S:
    move(rect.left()+int(rect.width()/2)-CHandleOffset, rect.bottom()-CHandleSize); break;
  case SW:
    move(rect.left(), rect.bottom()-CHandleSize); break;
  case W:
    move(rect.left(), rect.top()+int(rect.height()/2)-CHandleOffset); break;
  };
}


void THandle::mousePressEvent(QMouseEvent *ev){
  OffsetX = ev->pos().x();
  OffsetY = ev->pos().y();
}

void THandle::mouseMoveEvent(QMouseEvent *){
  QPoint newPos = mapToParent(mapFromGlobal(QCursor::pos()));

  switch(handlePosition()) {
  case N:
    rectangle.setTop(newPos.y()-OffsetY); break;
  case NE:
    rectangle.setTop(newPos.y()-OffsetY);
    rectangle.setRight(newPos.x()-OffsetX); break;
  case E:
    rectangle.setRight(newPos.x()-OffsetX); break;
  case SE:
    rectangle.setBottom(newPos.y()-OffsetY);
    rectangle.setRight(newPos.x()-OffsetX); break;
  case S:
    rectangle.setBottom(newPos.y()-OffsetY); break;
  case SW:
    rectangle.setLeft(newPos.x()-OffsetX);
    rectangle.setBottom(newPos.y()-OffsetY); break;
  case W:
    rectangle.setLeft(newPos.x()-OffsetX); break;
  case NW:
    rectangle.setLeft(newPos.x()-OffsetX);
    rectangle.setTop(newPos.y()-OffsetY); break;
  };
  emit(sigPositionRectChanged(rectangle));
}



