#include <iostream.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <qlined.h>
#include <qcombo.h>
#include <qpushbt.h>
#include <qobjcoll.h>

#include <kapp.h>

#include "TPropertyWidget.h"
#include "TEdit.h"
#include "TStore.h"


TPropertyWidget::TPropertyWidget(QWidget *parent, const char *name):
QWidget(parent, name) {
  initMetaObject();

  fRootObject=NULL;
  fActiveObject=NULL;
  comboCurrentObject = new QComboBox(FALSE, this, "Object Selector");
  comboCurrentObject->resize(width(), 21);
  comboCurrentObject->move(0,0);

  connect(comboCurrentObject, SIGNAL(activated(const char *)),
	  this,               SLOT(comboActivated(const char *)));
  updateObject(NULL, "");
  
  panner = new KPanner(this, "Panner", KPanner::O_VERTICAL, 50);
  panner->move(0, comboCurrentObject->height());

  fUpdatingProperties = FALSE;
  fActiveObject=NULL;
  fWidgetList.setAutoDelete(TRUE);
  fPropertyList.setAutoDelete(TRUE);

  fLayoutLeft = NULL;
  fLayoutRight = NULL;

  scrollBar = new QScrollBar(QScrollBar::Vertical, this, "Scroll Bar");
  connect(scrollBar, SIGNAL(valueChanged(int)), SLOT(scrollChanged(int)));

  setCaption("Property Editor");

  comboCurrentObject->raise();


  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup( "WindosPos" );
  if (config) {
    QString str;
    str = config->readEntry("PropertyWidget");
    if (str.isEmpty() || str=="")
      resize(256,256);
    else {
      int a,b,c,d;
      if (4 != sscanf(str.data(), "%d %d %d %d", &a, &b, &c, &d))
	resize (256,256);
      else
	setGeometry(a,b,c,d);
    }
  }
}



TPropertyWidget::~TPropertyWidget() {
  //  if (KApplication::APPCONFIG_READWRITE==KApplication::getKApplication()->getConfigState()) {

  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup( "WindosPos" );
    
  QString str;
  str.sprintf("%d %d %d %d", x(), y(), width(), height());
  config->writeEntry("PropertyWidget", str);
  config->sync();
    //  }
}


void TPropertyWidget::addTextChild(TStoreProperty storeProp) {
  QString s;
  QWidget *editor=NULL;
  

  s = "Label " + storeProp.name;
  QLabel *label = new QLabel(storeProp.name+" :", panner->child0(), s);
  CHECK_PTR(label);
  label->resize(100, 21);
  label->setMaximumSize(1000,21);
  label->setMinimumSize(30,21);
  label->setAlignment(AlignRight);
  label->show();

  fLayoutLeft->addWidget(label);

  s = "Editor " + storeProp.name;
  switch(storeProp.propertyType) {
  case ptText:
    editor = new TEdit(panner->child1(), s);
    CHECK_PTR(editor);
    connect(editor, SIGNAL(returnPressed()), this, SLOT(objectActivated()));
    connect(editor, SIGNAL(sigExit()), this, SLOT(objectActivated()));
    break;
  case ptList:
    editor = new QComboBox(panner->child1(), s);
    CHECK_PTR(editor);
    (fActiveObject->*storeProp.initFunc)(editor);
    connect(editor, SIGNAL(activated(int)), this, SLOT(objectActivated(int)));
    break;
  case ptButton:
    editor = new QPushButton(panner->child1(), s);
    CHECK_PTR(editor);
    connect(editor, SIGNAL(clicked()), this, SLOT(objectActivated()));
    break;
  };
  editor->resize(100, 21);
  editor->setMaximumSize(1000,21);
  editor->setMinimumSize(30,21);
  editor->show();
  
  fLayoutRight->addWidget(editor);


  fWidgetList.append(label);
  fWidgetList.append(editor);

  TProperty *prop = new TProperty;
  CHECK_PTR(prop);
  prop->widget = editor;
  prop->name = storeProp.name;
  prop->propType = storeProp.propertyType;
  prop->setFunc = storeProp.setFunc;
  prop->getFunc = storeProp.getFunc;
  prop->activateFunc = storeProp.activateFunc;
  prop->geometry = storeProp.geometry;
  
  fPropertyList.append(prop);
}





void TPropertyWidget::scrollChanged(int value) {
  panner->move(0, 0-(value-comboCurrentObject->height()) );
}


void TPropertyWidget::objectActivated(int) {
  if (sender()) {
    objectActivated(sender());
  }
}
    
void TPropertyWidget::objectActivated(void) {
  if (sender()) {
    objectActivated(sender());
  }
}
    
void TPropertyWidget::objectActivated(const QObject *) {
	QListIterator<TProperty> pit(fPropertyList);
	void *func(QObject *, QString);
	
	for (pit.toFirst() ; pit.current() ; ++pit) {
		if (pit.current()->widget==sender()) {
			break;
		}
	}
	if (pit.current()) {
		TStorePropertyGetFn getFn = pit.current()->getFunc;
		TStorePropertySetFn setFn = pit.current()->setFunc;
		TStorePropertyActivateFn actFn = pit.current()->activateFunc;

		QString old = (fActiveObject->*getFn)();
		switch(pit.current()->propType) {
		case ptList:
			(fActiveObject->*setFn)(((QComboBox *) sender())->currentText());
			break;
		case ptText:
			if (!(fActiveObject->*setFn)(((TEdit *) sender())->text()))
				((TEdit*)sender())->setText((fActiveObject->*getFn)());
			break;
		case ptButton:
			if (actFn)
				(fActiveObject->*actFn)();
			break;
		}
		if (pit.current()->geometry)
			emit(sigWidgetGeometryChanged(activeObject(),
										  QRect(((QWidget*)activeObject())->pos(),
												((QWidget*)activeObject())->size())));
		activeObject()->propertyChanged(pit.current()->name, old, 
										(fActiveObject->*getFn)() );
	}
}


void TPropertyWidget::setActive(void) {
  TStoreType *tree = fRootObject->find(sender());

  activeObject(tree);
}


void TPropertyWidget::activeObject(TStoreType *w) {
	if (w && fActiveObject!=w) {
		// We may have changed the BoundWindow we are working with, so
		// update the contents of the combo. This needs to be optimised
		// to only change if the root object has changed.
		updateObjectList(w);

		if ((!fActiveObject) || 
			(w->storeTypeName()!=fActiveObject->storeTypeName())) {
			fActiveObject = w;
      
			// delete all the current properties
			fWidgetList.clear();
			fPropertyList.clear();
			if (fLayoutLeft)
				delete fLayoutLeft;
			if (fLayoutRight)
				delete fLayoutRight;
      
			// Add the required properties for this class
			fLayoutLeft = new QBoxLayout(panner->child0(), QBoxLayout::Down);
			fLayoutRight = new QBoxLayout(panner->child1(), QBoxLayout::Down);
	
			TStorePropertyListIterator it(*w->getProperties());
			for (it.toFirst() ; it.current() ; ++it ) {
				addTextChild(*(it.current()));
			}
			calculateScrollBars();
		}
		fActiveObject = w;
		updateProperties();


		// set the current combo item to be the new object
		QString str;
		str = str.sprintf("%s:%s", w->object()->name(), w->storeTypeName().data());
		for (int i=0 ; i<comboCurrentObject->count() ; i++) {
			if (comboCurrentObject->text(i) == str) {
				comboCurrentObject->setCurrentItem(i);
				break;
			}
		}
	}
}


void TPropertyWidget::updateProperties(void) {
  if (!fUpdatingProperties) {
    fUpdatingProperties = TRUE;
    
    if (NULL==fActiveObject) {
      QListIterator<TProperty> it(fPropertyList);
      for (it.toFirst() ; it.current() ; ++it ) {
	if (it.current()->widget->inherits("TEdit"))
	  ((TEdit*)it.current()->widget)->setText("");
	if (it.current()->widget->inherits("QComboBox"))
	  ((QComboBox*)it.current()->widget)->setCurrentItem(0);
      }
    }
    else {
      QListIterator<TProperty> it(fPropertyList);
      for (it.toFirst() ; it.current() ; ++it ) {
	if (it.current()->widget->inherits("TEdit")) {
	  QString s = (fActiveObject->*it.current()->getFunc)();
	  ((TEdit*)it.current()->widget)->setText(s);
	}
	if (it.current()->widget->inherits("QComboBox")) {
	  QComboBox *combo = (QComboBox*) it.current()->widget;
	  QString s = (fActiveObject->*it.current()->getFunc)();

	  for (int cur=0 ; cur<combo->count() ; cur++) {
	    if (0==strcmp( combo->text(cur), s))
	      combo->setCurrentItem(cur);
	  }
	}
	if (it.current()->geometry)
	  emit(sigWidgetGeometryChanged(activeObject(),
					QRect(((QWidget*)activeObject())->pos(),
					      ((QWidget*)activeObject())->size())));
      }
    }
    fUpdatingProperties = FALSE;
  }
}
  


void TPropertyWidget::widgetGeometryChanged(QObject *o, const QRect &r) {
  updateProperties();
  emit(sigWidgetGeometryChanged(o, r));
}



void TPropertyWidget::resizeEvent(QResizeEvent *) {
  calculateScrollBars();
  comboCurrentObject->resize(width(), comboCurrentObject->height());
}


void TPropertyWidget::calculateScrollBars(void) {
  int visHeight = height() - comboCurrentObject->height();
  int totalHeight = 21 * fPropertyList.count();

  if ( (totalHeight - visHeight) > 0) {
    scrollBar->setRange(0, totalHeight-visHeight);
    scrollBar->setSteps(1, visHeight);
    scrollBar->resize( 15, height()-comboCurrentObject->height() );
    scrollBar->move(width() - scrollBar->width(), comboCurrentObject->height() );
    scrollBar->show();
    panner->resize(width()-scrollBar->width(), totalHeight);
  }
  else {
    scrollBar->hide();
    panner->move(0, comboCurrentObject->height() );
    panner->resize(width(), totalHeight);
  }
}


void TPropertyWidget::addNewObject(TStoreType *tree) {
  QString str;

  if (!updateObjectList(tree)) {
    if (0!=strcmp(tree->storeTypeName(),"THandle")) {
      str = str.sprintf("%s:%s", tree->object()->name(), tree->storeTypeName().data() );

      // Add the object in sorted order
      for (int i=0 ; i<comboCurrentObject->count() ; i++) {
	if (str < comboCurrentObject->text(i)) {
	  comboCurrentObject->insertItem(str, i);
	  return;
	}
      }
      comboCurrentObject->insertItem(str, -1);
    }
  }
}




void TPropertyWidget::updateObject(TStoreType *tree, QString oldName) {
  QString str;
  QString old;

  if (tree==NULL)
    return;
  
  old = old.sprintf("%s:%s", (const char *)oldName, tree->storeTypeName().data());
  str = str.sprintf("%s:%s", tree->object()->name(), tree->storeTypeName().data());

  for (int i=0 ; i<comboCurrentObject->count() ; i++) {
    if (comboCurrentObject->text(i) == old) {
      comboCurrentObject->removeItem(i);
      break;
    }
  }
  
  for (int i=0 ; i<comboCurrentObject->count() ; i++) {
    if (str < comboCurrentObject->text(i)) {
      comboCurrentObject->insertItem(str, i);
      comboCurrentObject->setCurrentItem(i);
      return;
    }
  }
  comboCurrentObject->insertItem(str, -1);
  comboCurrentObject->setCurrentItem(comboCurrentObject->count());
}




void TPropertyWidget::comboActivated(const char *text) {
  QString lClass, lName;
  
  if (!fActiveObject)
    return;
  
  // Find the class and name
  QString str = text;

  int pos = str.find(":");
  if (pos != -1) {
    lName = str.mid(0, pos);
    lClass = str.mid(pos+1, str.length());
    if (lName == "(null)")
      lName = "";
    
    TStoreType *ot = fRootObject;
    while (ot) {
      if ((ot->storeTypeName() == lClass) &&
	  (ot->object()->name() == lName))
	break;
      ot = ot->next();
    }

    if (ot) {
      emit( sigObjectChanged(ot->object()));
    }
  }
}




bool TPropertyWidget::updateObjectList(TStoreType *tree) {
	if (!tree)
		return FALSE;

  TStoreType *ptr = tree->root();

  if (ptr != fRootObject) {
    QString str;

    comboCurrentObject->clear();
    fRootObject=ptr;
    for ( ; ptr ; ptr=ptr->next() )
      addNewObject(ptr);

    str = str.sprintf("%s:%s", tree->object()->name(), tree->storeTypeName().data());


    for (int i=0 ; i<comboCurrentObject->count() ; i++) 
      if (comboCurrentObject->text(i) == str) 
	comboCurrentObject->setCurrentItem(i);
    return TRUE;
  }
  else
    return FALSE;
}

