#include "TQuestionDialog.h"

TQuestionDialog::TQuestionDialog(const char *title,
				 const char *message,
				 QWidget *parent,
				 const char *name) :  QDialog(parent, name, TRUE) {
  initMetaObject();
  
  edit = new QLineEdit(this, "Line Edit");
  CHECK_PTR(edit);
  edit->setText(message);
  connect(edit, SIGNAL(returnPressed()), this, SLOT(accept()));

  label = new QLabel(title, this, "Title Label");
  CHECK_PTR(label);

  okBtn = new QPushButton("OK", this, "OK Button");
  CHECK_PTR(okBtn);
  connect(okBtn, SIGNAL(clicked()), this, SLOT(accept()));

  cancelBtn = new QPushButton("Cancel", this, "Cancel Button");
  CHECK_PTR(cancelBtn);
  connect(cancelBtn, SIGNAL(clicked()), this, SLOT(reject()));


  cancelBtn->adjustSize();
  okBtn->resize(cancelBtn->size());


  setMinimumSize(okBtn->width()*2 + 30, okBtn->height()*3+40);

  label->setMinimumSize(okBtn->width()*4, 0);
  label->adjustSize();
  label->move(10,10);

  edit->setMinimumSize(okBtn->width()*4, 0);
  edit->adjustSize();
  edit->move(10, 20+label->height());
  
  okBtn->move(okBtn->width()-5, edit->y()+edit->height()+10);
  cancelBtn->move(2*okBtn->width()+5, edit->y()+edit->height()+10);
}

const char *TQuestionDialog::text(void) {
  return edit->text(); 
}


void TQuestionDialog::resizeEvent(QResizeEvent *) {
  okBtn->move( width()/2 - (okBtn->width()+5), height() - (okBtn->height()+10));
  cancelBtn->move( width()/2 + 5, height() - (okBtn->height()+10));

  edit->setGeometry(10, 
		    height() - (okBtn->height() +edit->height()+20),
		    width()-20,
		    edit->height());
  label->setGeometry(10, 
		     10,
		     width()-20,
		     edit->y()-20);
}


void TQuestionDialog::focusInEvent(QFocusEvent *) {
  edit->setFocus();
}

