#ifndef _SIGNAL_SLOT_H_
#define _SIGNAL_SLOT_H_

#include <iostream.h>

#include <qlist.h>
#include <qstring.h>

class TStoreType;

enum TConnectionType { ctSignal, ctSlot };
enum TSlotPrivacy { spPublic, spProtected, spPrivate};

class TSignalSlot {
friend ostream &operator<<(ostream &os, TSignalSlot &l);
public:
	~TSignalSlot();
	QString name;
	QString args;
	TConnectionType type;
	bool created;
protected:  
	TSignalSlot(const char *, const char *, TConnectionType);
};



class TSlot: public TSignalSlot {
public:
	TSlot(const char *, const char *, TSlotPrivacy p=spPublic, bool v=FALSE);
	~TSlot();

	TSlotPrivacy privacy;
	bool isVirtual;
};

class TSlotList: public QList<TSlot> {
friend ostream &operator<<(ostream &os, TSlotList &l);
public:
	TSlotList();
	~TSlotList();
	TSlot *find(QString, QString);
	TSlot *find(QString);
private:
  int compareItems(GCI s1, GCI s2);
};
typedef QListIterator<TSlot> TSlotListIt;




class TSignal: public TSignalSlot {
public:
	TSignal(const char *, const char *);
	~TSignal();
};

class TSignalList: public QList<TSignal> {
friend ostream &operator<<(ostream &os, TSignalList &l);
public:
	TSignalList();
	~TSignalList();

	TSignal *find(QString, QString);
	TSignal *find(QString);
private:
  int compareItems(GCI s1, GCI s2);
};

typedef QListIterator<TSignal> TSignalListIt;




class TConnection {
public:
  TConection();
	~TConnection() {;};

  QString destName; // for use only when loading file in
  TStoreType *dest;
  TSignalSlot *connection;
};
typedef QList<TConnection> TConnectionList;
typedef QListIterator<TConnection> TConnectionListIt;



// A list of these needs to be stored with every TObjectTree
// one for every signal that the object has.
class TLinkedConnections {
public:
  TSignal *source;
  TConnectionList connections;
};

class TLinkedConnectionsList: public QList<TLinkedConnections> {
public:
  TLinkedConnections *find(QString s);
  TLinkedConnections *find(QString n, QString a);
};
typedef QListIterator<TLinkedConnections> TLinkedConnectionsListIt;



#endif /* _SIGNAL_SLOT_H_ */
