/*
** $Source: /usr/local/share/cvs/frugal/mawc/mawc/TStoreProperty.cpp,v $
** $Author: frugal $
** $Date: 1998/01/13 18:48:43 $
** $Revision: 1.1.1.1 $
** $State: Exp $
** $Log: TStoreProperty.cpp,v $
** Revision 1.1.1.1  1998/01/13 18:48:43  frugal
**
** Revision 1.1.1.1  1998/01/09 12:01:32  frugal
** MAWC initial import
**
** Revision 1.3  1997/07/09 19:11:01  frugal
** - Initfunc now takes a second argument
**
** Revision 1.2  1997/06/01 13:52:21  frugal
** - Changed the base type from QWidget to QObject, to allow for future
**   expansion into layouts.
**
** Revision 1.1  1997/03/27 01:01:34  frugal
** Initial revision
**
**
** All source code written by Frugal (frugal@wardrobe.demon.co.uk)
*/

#include "TStoreProperty.h"
#include "TStoreType.h"


TStoreProperty::TStoreProperty(QString n,
				   TPropertyType t,
				   TStorePropertySetFn s,
				   TStorePropertyGetFn g,
				   TStorePropertyInitFn i,
				   TStorePropertyActivateFn a,
			       bool geom) {
  name = n;
  propertyType = t;
  setFunc = s;
  getFunc = g;
  initFunc = i;
  activateFunc = a;
  geometry = geom;
}

ostream &operator<<(ostream &os, TStoreProperty &e) {
  os << "\t\t{ name='" << e.name <<
    "', type=" << e.propertyType <<
      "', geom=" << e.geometry <<
	", set=" << (void *)&(e.setFunc) <<
	  ", get=" << (void *)&(e.getFunc) <<
	    ", init=" << (void *)&(e.initFunc) <<
	      ", activate=" << (void*)&(e.activateFunc) << " } ";
  return (os);
}




/*****************************************
 **
 **  Class: TStorePropertyList
 **
 *****************************************/

ostream &operator<<(ostream &os, TStorePropertyList &l) {
  TStorePropertyListIterator it(l);
  for (it.toFirst() ; it.current() ; ++it)
    os << *(it.current()) << endl;
  return (os);
}

int TStorePropertyList::compareItems(GCI s1, GCI s2) {
  return (strcmp(((TStoreProperty*)s1)->name, ((TStoreProperty*)s2)->name));
};



TStoreProperty *TStorePropertyList::find(QString s) {
  TStorePropertyListIterator it(*this);
  for ( ; it.current() ; ++it)
    if (it.current()->name==s)
      return it.current();
  return NULL;
}




