#ifndef _TSTORETYPEQWIDGET_H_
#define _TSTORETYPEQWIDGET_H_


#include "TStoreType.h"

TStoreType* createTypeQWidget(TStoreType*, TLayoutWindow *);
QPixmap *pixmapQWidget();
bool isCreatableQWidget();
bool isBaseClassQWidget();


/*!
  \class TStoreTypeQWidget TStoreTypeQWidget.h
  \brief The TStoreTypeQWidget provides the dynamic functionality
  for a QWidget to be added to the component library for MAWC
  */
class TStoreTypeQWidget: public TStoreType {
  Q_OBJECT
public:
  TStoreTypeQWidget(TStoreType *parent, TLayoutWindow *);
  virtual ~TStoreTypeQWidget();

  QString storeTypeName();
  QString headerFile();
  TObjectType type();

  void writeHFile(QTextStream &os, QString);
  void writeCFileConstructor(QTextStream &os, QString, QString);
  void writeCFileProperties(QTextStream &os, QString var);
  void writeCFileData(QTextStream &os, QString var);
  
  void writeLayout(QTextStream &os, int tabs);
  void readLayoutItem(QTextStream &os,QString);
  
  void copyDetails(TStoreType *);

  bool isCreatable();
  bool isVisible();
  bool canItHaveChildren();
protected:
  void writeCFilePalette(QTextStream &, QString);
  void writeCFileBackgroundPixmap(QTextStream &, QString);
  void addProperties();
  void addSlots();



  bool QWidgetSetCaptionFunc(QString AValue);
  QString QWidgetGetCaptionFunc();

  bool QWidgetSetXFunc(QString AValue);
  QString QWidgetGetXFunc();

  bool QWidgetSetYFunc(QString AValue);
  QString QWidgetGetYFunc();

  bool QWidgetSetWidthFunc(QString AValue);
  QString QWidgetGetWidthFunc();

  bool QWidgetSetHeightFunc(QString AValue);
  QString QWidgetGetHeightFunc();

  bool QWidgetSetMinWidthFunc(QString AValue);
  QString QWidgetGetMinWidthFunc();

  bool QWidgetSetMinHeightFunc(QString AValue);
  QString QWidgetGetMinHeightFunc();

  bool QWidgetSetMaxWidthFunc(QString AValue);
  QString QWidgetGetMaxWidthFunc();

  bool QWidgetSetMaxHeightFunc(QString AValue);
  QString QWidgetGetMaxHeightFunc();

  bool QWidgetSetBkgPixmapFunc(QString);
  QString QWidgetGetBkgPixmapFunc();
  void QWidgetActivateBkgPixmapFunc();

  bool QWidgetSetPaletteFunc(QString AValue);
  QString QWidgetGetPaletteFunc();
  void QWidgetActivatePaletteFunc();

  bool QWidgetSetXIncrementFunc(QString AValue);
  QString QWidgetGetXIncrementFunc();

  bool QWidgetSetYIncrementFunc(QString AValue);
  QString QWidgetGetYIncrementFunc();
 
  bool QWidgetSetFontFunc(QString AValue);
  QString QWidgetGetFontFunc();
  void QWidgetActivateFontFunc();
 
  bool QWidgetSetMouseTrackingFunc(QString AValue);
  QString QWidgetGetMouseTrackingFunc();
  void QWidgetInitMouseTrackingFunc(QObject *);
};


extern TStoreTypeQWidget *gStoreTypeQWidget;

#endif /* _TSTORETYPEQWIDGET_H_ */
