#ifndef _TBOXLAYOUTWINDOW_H_
#define _TBOXLAYOUTWINDOW_H_

#include <qdialog.h>
#include <qpushbt.h>

#include <TObjectTree.h>
#include <TDataListBoxDlg.h>
#include "TBoxLayoutTable.h"


typedef struct TTaggedObject {
  TStoreType *tree;
  bool inLayout;
} TTaggedObject;


class TBoxLayoutWindow: public QDialog {
  Q_OBJECT
public:
  TBoxLayoutWindow(TStoreType *, QWidget *parent=NULL, const char *name=NULL);
  ~TBoxLayoutWindow();

  QList<TBoxLayoutDataItem> *items() { return boxTable->list(); };
  void items(QList<TBoxLayoutDataItem> &);

protected:
  void setTree(TStoreType *);
protected slots:
  void okClicked();
  void addWidget();
  void addLayout();
  void addSpace();
  void addStretch();
  void addStrut();
  void deleteItem();
private:
  void populateObjectListBox(TDataListBoxDlg *widgetList, const char *dtype);
  void tagObject(TStoreType *, bool);

  QPushButton *btnOk;
  QPushButton *btnCancel;
  QPushButton *btnDelete;
  QPushButton *btnWidget;
  QPushButton *btnLayout;
  QPushButton *btnSpace;
  QPushButton *btnStretch;
  QPushButton *btnStrut;
  TBoxLayoutTable *boxTable;

  QList<TTaggedObject> fTaggedObjects;
  TStoreType *fTree;
};


#endif /* _TBOXLAYOUTWINDOW_H_ */
