#ifndef _TSTORETYPEQBOXLAYOUT_H_
#define _TSTORETYPEQBOXLAYOUT_H_

#include <qlist.h>
#include <qlayout.h>

#include "TStoreTypeQLayout.h"




class TBoxLayoutDataItem {
public:
  TBoxLayoutDataItem();
  TBoxLayoutDataItem(TBoxLayoutDataItem &);

  TBoxLayoutDataItem &operator=(TBoxLayoutDataItem &);

  enum TBoxLayoutDataType { Widget, Layout, Stretch, Strut, Space};

  TBoxLayoutDataType type;
  TStoreType *objectTree;
  int size;
  int alignment;
  QString name;
};

class TBoxLayoutData {
public:
  TBoxLayoutData();
  TBoxLayoutData(TBoxLayoutData &);

  TBoxLayoutData &operator=(TBoxLayoutData &);

  QBoxLayout::Direction direction;
  int border;
  QList<TBoxLayoutDataItem> items;
  QString layoutName;
  QString parentName;
};


class TStoreTypeQBoxLayout: public TStoreTypeQLayout {
	Q_OBJECT
public:
  TStoreTypeQBoxLayout(TStoreType *, TLayoutWindow *);

  QString storeTypeName();
  QString headerFile();

  void writeHFile(QTextStream &os, QString);
  void writeCFileConstructor(QTextStream &os, QString, QString);
  void writeCFileProperties(QTextStream &os, QString);
  
  void writeLayout(QTextStream &os, int tabs);
  void readLayoutItem(QTextStream &os, QString);
  
  void copyDetails(TStoreType *oldObj);

  bool isCreatable();

  virtual void rebuildLayout();
  virtual void recreateLayout(QLayout *parent);
  virtual void repopulateLayout();
  virtual void writePropertiesLayoutTree(QTextStream &, QString);

  void propertyChanged(const char *, const char *, const char *);
  void postLayoutLoad();

  virtual void rebuild(bool);
  virtual void deleteLayoutTree();
protected:
  void addProperties();
  virtual void layoutMemberDeleted(TStoreType *);

	bool QBoxLayoutSetBorderFunc(QString AValue);
	QString QBoxLayoutGetBorderFunc();
	
	bool QBoxLayoutSetDirectionFunc(QString AValue);
	QString QBoxLayoutGetDirectionFunc();
	void QBoxLayoutInitDirectionFunc(QObject *);
	
	bool QBoxLayoutSetLayoutFunc(QString);
	QString QBoxLayoutGetLayoutFunc();
	void QBoxLayoutActivateLayoutFunc();
private:
};

TStoreType *createStoreTypeQBoxLayout(TStoreType *, TLayoutWindow *);

#endif /* _TSTORETYPEQBOXLAYOUT_H_ */
