#include "qtree.h"
#include <stdlib.h>


QTree::QTree(QTree *p) {
  fDepth = -1;
  fparent =NULL;
  parent(p);
}


QTree::QTree( const QTree &t) {
  fDepth = t.fDepth;
  fparent = t.parent();
}



QTree::~QTree() {
  ;
}



QTree *QTree::parent() const { 
  return fparent; 
}
  
void QTree::parent(QTree *p) {
  if (fparent!=p) {
    if (fparent)
      fparent->removeChild(this);
    fparent = p;
    if (fparent)
      fparent->addChild(this);
    emit(sigParentChange(p));
//    updateDepths();
  }
}


uint QTree::numNodes(bool recursive) const {
  uint count = fchildren.count();
  if (recursive) {
    QListIterator<QTree> it(fchildren);
    for ( ; it.current() ; ++it)
      count += it.current()->numNodes(TRUE);
  }
  return (count);
};

QTree *QTree::child(uint i) {
  return fchildren.at(i);
}


QTree *QTree::root() {
  return fparent ? fparent->root() : this;
}

QTree *QTree::nextSibling() {
  if (!parent())
    return NULL;

  int pos = positionInParent();
  if ( pos < (int)(fparent->numNodes()-1) )
    return fparent->child(pos+1);
  return NULL;
}

QTree *QTree::prevSibling() {
  if (!fparent)
    return NULL;
  int pos = positionInParent();
  if (pos > 0)
    return fparent->child(pos-1);
  return NULL;
}



QTree *QTree::next(bool allowBranching) {
  if (!allowBranching) {
    int pos = positionInParent();
    if (!parent())
      return NULL;
    if (pos<(int)(fparent->numNodes()-1))
      return fparent->child(pos+1);
    else
      return fparent->nextAfter(this);
      //return NULL;
  }
  else {
    if (numNodes()) 
      return child(0);
    else {
      if (!parent())
	return NULL;
      int pos = positionInParent();
      if (pos<(int)(fparent->numNodes()-1))
	return fparent->child(pos+1);
      else
	return fparent->nextAfter(this);
    }
  }
  return NULL;
}

  
QTree *QTree::prev(bool allowBranching) {
  if (!fparent)
    return NULL;
  int pos = positionInParent();
  if (!allowBranching) {
    if (pos > 0)
      return fparent->child(pos-1);
    else
      return NULL;
  }
  else {
    if (pos > 0)
      return fparent->child(pos-1)->rightmostChild();
    else
      return fparent;
  }
  return NULL;
}


QTree *QTree::find(QTree *a, bool aFromThis) {
  if (aFromThis && (a==this))
    return (this);

  QTree *tmp=next();
  while(tmp && (a!=tmp))
    tmp = tmp->next();
  return tmp;
};



int QTree::positionInParent() {
  return fparent ? fparent->fchildren.find(this) : -1;
}


void QTree::positionInParent(int p) {
  if (p<0)
    p=0;
  if (p>=(int)parent()->numNodes())
    p=parent()->numNodes()-1;

  if (p!=positionInParent()) {
    parent()->fchildren.remove(this);
    parent()->fchildren.insert(p, this);
  }
}
      
    
      

QTree *QTree::rightmostChild(void) {
  if (numNodes()>0)
    return fchildren.getLast()->rightmostChild();
  else
    return this;
}
  
QTree *QTree::nextAfter(QTree *after) {
  if (!after)
    return NULL;
  int pos = fchildren.find(after);
  if (pos==-1) 
    return (NULL);
  if (pos<(int)(numNodes()-1))
    return child(pos+1);
  else 
    return fparent ? fparent->nextAfter(this) : (QTree *)NULL;
}
  
void QTree::addChild(QTree *aNewChild) {
  fchildren.append(aNewChild);
  aNewChild->updateDepths();
  emit(sigAddChild(aNewChild));
}
  
void QTree::removeChild(QTree *aDeleteThis) {
  int pos = fchildren.find(aDeleteThis);
  if (pos!=-1) {
    emit(sigRemoveChild(aDeleteThis));
    fchildren.remove(pos);
  }
}

void QTree::updateDepths(void) {
  int olddepth = fDepth;
  if (fparent) 
    fDepth = fparent->depth()+1;
  else
    fDepth = 0;

  if (fDepth!=olddepth) {
    emit(sigSetDepth(fDepth));
    
    QListIterator<QTree> it(fchildren);
    for ( ; it.current() ; ++it)
      it.current()->updateDepths();
  }
}



