/* fpios.cc
 * Written by Joshua Rowe
 * file-based persistent object streams
 */

#include	"fpios.hh"
#include	<fcntl.h>
#include	<unistd.h>
#include	<errno.h>

fdpstreambuf::fdpstreambuf()
{
  fd	= -1;
}

fdpstreambuf::fdpstreambuf(int afd, int aflags)
:	pstreambuf(aflags)
{
  fd	= afd;
}

fdpstreambuf::~fdpstreambuf()
{
  if (flags & pstream::xxclose)
    close();
}

void	fdpstreambuf::close()
{
  if (::close(fd) == -1)
    err	= errno;
  else
    err	= 0;
  fd	= -1;
}

void	fdpstreambuf::open(int afd, int aflags)
{
  if (flags & pstream::xxclose)
    close();
  fd	= afd;
  flags	= aflags;
}

pvoid	fdpstreambuf::read(pvoid d, int l)
{
  if (error())
    return	0;
  if (::read(fd, d, l) == -1)
    err	= errno;
  else
    err	= 0;
  if (error())
    return	0;
  else
    return	d;
}

void	fdpstreambuf::write(pvoid d, int l)
{
  if (error())
    return;
  if (::write(fd, d, l) == -1)
    err	= errno;
  else
    err	= 0;
}

fdpstream::fdpstream()
:	pstream(0, 0)
{
}

fdpstream::fdpstream(int afd, int aflags)
:	pstream(0, flags)
{
  open(afd, aflags);
}

void	fdpstream::open(int afd, int aflags)
{
  if ((buf != 0) & (flags & xxkill))
    delete	buf;
  buf	= new fdpstreambuf(afd, aflags);
  flags	= aflags;
  flags	|= xxkill;
}

ifdpstream::ifdpstream()
:	fdpstream(0, 0)
{
}

ifdpstream::ifdpstream(int afd, int aflags)
:	fdpstream(afd, aflags)
{
}

ofdpstream::ofdpstream()
:	fdpstream(0, 0)
{
}

ofdpstream::ofdpstream(int afd, int aflags)
:	fdpstream(afd, aflags)
{
}

iofdpstream::iofdpstream()
:	fdpstream(0, 0)
{
}

iofdpstream::iofdpstream(int afd, int aflags)
:	fdpstream(afd, aflags | xxread | xxwrite)
{
}

fpstreambuf::fpstreambuf(char *aname, int aflags, int amode)
:	fdpstreambuf()
{
  open(aname, aflags, amode);
}

void	fpstreambuf::open(char *aname, int aflags, int amode)
{
  int	fd	= ::open(aname,
			 ((aflags & pstream::xxwrite) ? O_WRONLY : 0) |
			 ((aflags & pstream::xxread)  ? O_RDONLY : 0) |
			 ((aflags & pstream::xxappen) ? O_APPEND : 0) |
			 ((aflags & pstream::xxtrunc) ? O_TRUNC  : 0) |
			 ((aflags & pstream::xxexcl)  ? O_EXCL   : 0) |
			 ((aflags & pstream::xxcreat) ? O_CREAT  : 0),
			 amode);
  if (fd == -1)
    error(errno);
  else
    error(0);
  fdpstreambuf::open(fd, aflags | pstream::xxclose);
}

fpstream::fpstream()
{
}

fpstream::fpstream(char *aname, int aflags, int amode)
{
  open(aname, aflags, amode);
}

void	fpstream::open(char *aname, int aflags, int amode)
{
  if (buf != 0)
    delete	buf;
  buf	= new fpstreambuf(aname, aflags, amode);
  flags	= aflags;
}

ifpstream::ifpstream()
{
}

ifpstream::ifpstream(char *aname, int aflags, int amode)
{
  open(aname, aflags | xxread, amode);
}

ofpstream::ofpstream()
{
}

ofpstream::ofpstream(char *aname, int aflags, int amode)
{
  open(aname, aflags | xxwrite, amode);
}

iofpstream::iofpstream()
{
}

iofpstream::iofpstream(char *aname, int aflags, int amode)
{
  open(aname, aflags | xxwrite | xxappen | xxread, amode);
}

