/* test.cc
 * Written by Joshua Rowe
 * Test program for the persistent object stream library
 */

#include	"pios.hh"
#include	<unistd.h>
#include	<fcntl.h>
#include	"stdio.h"
#include	<string.h>
#include	"fpios.hh"

class	tstobj	: public pstreamable
{
  virtual char *	streamableName() const
    { return "tstobj"; };
protected:
  virtual pvoid	read(ipstream &is);
  virtual void	write(opstream &os);
  int	pf;
public:
  tstobj *	next, * prev, * child;
  int	data;
  virtual int	print(int i=0);
  void		indent(int i);
  tstobj(int ad, tstobj * anext, tstobj * aprev);
  tstobj(pstreamableInit);
  static pstreamable *	build();
};

tstobj::tstobj(pstreamableInit)
{
}

pstreamable *	tstobj::build()
{
  return	new tstobj(pstreamableinit);
}

pstreamreg	regtstobj("tstobj", tstobj::build, __PSTREAM_DELTA(tstobj));

opstream &	operator <<(opstream & os, tstobj *p)
{
  return	os << (pstreamable *)p;
}

ipstream &	operator >>(ipstream & is, tstobj *&p)
{
  return	is >> (pvoid &)p;
}

tstobj::tstobj(int ad, tstobj * a, tstobj * b)
{
  pf	= 0;
  data	= ad;
  next	= a;
  prev	= b;
  child	= 0;
}

void	tstobj::indent(int i)
{
  for (; i>0 ; i--)
    printf(" ");
}

int	tstobj::print(int i)
{
  if (pf)
    return 0;
  pf++;
  indent(i);
  printf(streamableName());
  printf(":\n");
  indent(i + 2);
  printf("%p:  pf: %i  data: %i  next: %p  prev: %p\n", this, pf, data, next, prev);
  if (child)
    child->print(i+4);
  if (next)
    next->print(i);
  pf--;
  return	1;
}

pvoid	tstobj::read(ipstream & is)
{
  is >> data >> next >> prev >> pf >> child;
  return this;
}

void	tstobj::write(opstream & os)
{
  os << data << next << prev << pf << child;
}

class	tstobj2	: public tstobj
{
  virtual char *	streamableName()	const
    { return "tstobj2"; }
protected:
  virtual pvoid	read(ipstream &is);
  virtual void	write(opstream &os);
public:
  char *	data2;
  tstobj2(int adata, char * astring, tstobj *anext, tstobj *aprev);
  tstobj2(pstreamableInit);
  static pstreamable *	build();
  virtual int	print(int i=0);
};

pstreamreg	regtstobj2("tstobj2", tstobj2::build, __PSTREAM_DELTA(tstobj2));

tstobj2::tstobj2(int adata, char * astring, tstobj *anext, tstobj *aprev)
:	tstobj(adata, anext, aprev)
{
  data2	= new char[strlen(astring) + 1];
  strcpy(data2, astring);
}

tstobj2::tstobj2(pstreamableInit)
:	tstobj(pstreamableinit)
{
}

pstreamable *	tstobj2::build()
{
  return	new tstobj2(pstreamableinit);
}

pvoid	tstobj2::read(ipstream &is)
{
  tstobj::read(is);
  is >> data2;
  return this;
}

void	tstobj2::write(opstream &os)
{
  tstobj::write(os);
  os << data2;
}

int	tstobj2::print(int i)
{
  if (tstobj::print(i))
    {
      indent(i + 2);
      printf("data2: %s\n", data2);
      return 1;
    }
  else
    return 0;
}

void	writetest()
{
  printf("Write test...\n");
  ofpstream	os("stream.out");
  tstobj *	a = new tstobj(1,0,0);
  tstobj *	b = new tstobj(2,0,a);
  tstobj *	c = new tstobj(3,0,b);
  tstobj *	d = new tstobj2(4,"something",a,c);
  tstobj *	e = new tstobj2(4, "anything else", 0, 0);
  tstobj *	f = new tstobj2(4, "cool stuff!", 0, e);
  a->next	= b;
  b->next	= c;
  c->next	= d;
  a->prev	= d;
  b->child	= e;
  e->next	= f;
  a->print(0);
  os << a;
}

void	readtest()
{
  printf("Read test...\n");
  ifpstream	is("stream.out");
  tstobj *	a;
  is >> a;
  a->print(0);
}

int	main(int argc, char **argv)
{
  writetest();
  readtest();
}
