package rolodex;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.Serializable;

public class Contact implements Serializable
{
  private String name = null;
  static private boolean debug;
  
  static
  {
    String sdebug = System.getProperty( "debug" );
    if ( sdebug != null && sdebug.equalsIgnoreCase( "true" ) )
    {
      debug = true;
    }
    else
    {
      debug = false;
    }
  }
  
  public Contact()
  {
    setName();
  }

  public Contact( String s )
  {
    name = s;
  }

  public void setName()
  {
    while (true)
    {
      try
      {
        BufferedReader input = new BufferedReader( new InputStreamReader(System.in));
        System.out.print( "Enter Contact Name: " );
        name = input.readLine();
        if ( debug )
        {
          IOException testexcep = new IOException ( "Test Readline" );
          throw testexcep; 
        }
        break;
      }  
      catch ( IOException ioe )
      {
        System.out.println ( ioe.toString() );
        ioe.printStackTrace();
        if ( debug )
        {
          break; 
        }       
      }             
    }
  }

  public String getName()
  {
    return(name);
  }

  public void show()
  {
    System.out.println ( "Contact: " + name );
  }

  public String toString ()
  {
    return ( show() );
  }

  static public void main ( String args[] )
  {
    Contact mycontact = new Contact();
    mycontact.show();
  }
}