// game.cpp

#include "game.h"

namespace Seahunt
{

Game::Game()
{
  status = true;
  player = new Player();
  if ( player == 0 )
  {
    std::cerr << "Memory Allocation Error!" << std::endl;
    status = false;
  }
  ocean = new Ocean();
  if ( ocean == 0 )
  {
    std::cerr << "Memory Allocation Error!" << std::endl;
    status = false;
  }
}

Game::~Game()
{
  if ( ocean )
  {
    delete ocean;
    ocean = 0;
  }
  if ( player )
  {
    delete player;
    player = 0;
  }
}

void
Game::Play()
{
  bool loop_exit = false;
  int more = 0;  

  /* Place the sub in the ocean */
  for ( int i=0; i<ocean->Get_target_count(); i++ )
  {
    ocean->PlaceTarget();
  }
  
  while ( !loop_exit )
  {

    if ( player->Hit(ocean) )
    {
      player->Show();
    }
    
    if ( ocean->Get_active_targets() == 0 )
    {
      std::cout << "You Win! and Get an A Grade!" << std::endl;
      loop_exit = true;
      continue;
    }
    else if ( player->Get_number_tries() > MAXTRIES )
    {
      std::cout << "You are a LOSER! and Get an D Grade!" << std::endl;
      loop_exit = false;
      continue;     
    }

    Utility::UserEntry( "Hit Again 0-No 1-Yes 2-Ocean 3-Targets", more, 0, 4 );
    
    switch ( more )
    {
      case 0:
      {
        loop_exit = true;
        continue;         
      }
      break;
        
      case 2:
      {
        ocean->Show();
      }
      break;

      case 3:
      {
        ocean->ShowTargets();
      }

      case 1:   // fall through 
      default:
      {
      }
      break;
    }
  }

  player->Show();
  Utility::WaitKey();

}

} // namespace