// target.cpp

#include "target.h"

namespace Seahunt
{

static const std::string StatusString[] = 
{ 
  "Unknown",
  "No Damage",
  "Damaged",
  "Dead"
}; 

Target::Target( std::string n, int a, int d )
{
  name = n;
  armor  = a;
  hits   = 0;
  depth_limit = d;
  status = NO_DAMAGE;
  #ifdef TARGET_TEST
  std::cout << "Constructed Target: " << name << std::endl;
  Show();
  #endif
}

Target::~Target()
{
  #ifdef TARGET_TEST
  std::cout << "Destructed Target: " << name << std::endl;
  Show();
  #endif
}

TargetStatus
Target::Get_status ( void ) const
{
  return ( status );
}

int 
Target::Get_depth_limit ( void )
{
  return( depth_limit );
}

std::string
Target::Get_name ( void ) const
{
  return(name);
}

bool
Target::Hit ( void )
{
  bool hit_state = false;
  if ( hits < armor )
  {
    hits++;
    if ( hits == armor )
    {
      status = DEAD;
    }
    else
    {
      status = DAMAGE;
    }
    hit_state = true;
  }
  else
  {
    status = DEAD;
  }
  return(hit_state);
}

void
Target::Reset ( void )
{
  hits = 0;
  status = NO_DAMAGE;
}

void 
Target::Show ( void ) const
{
  std::cout << name << std::endl
            << "Armor    : " << armor << std::endl
            << "Hits     : " << hits << std::endl
            << "Status   : " << StatusString[static_cast<int>(status)] << std::endl;
}

} // namespace Seahunt

#ifdef TARGET_TEST
int
main ( void )
{

  Seahunt::Target t( "Generic Target", 3 );

  t.Hit();
  t.Show();
  t.Hit();
  t.Show();
  t.Hit();
  t.Show();
  t.Hit();
  t.Show();

  return (0);

}
#endif // UNIT_TEST

// eof target.cpp

