
// Copyright (C) 1999 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "smdi.h"
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define	SMDI_CTRL_D	0x04

SMDI::SMDI(int pri) :
Thread(NULL, pri), Mutex()
{
	time(&lastio);
}

SMDI::~SMDI()
{
	Terminate();
};

int SMDI::getActivity(void)
{
	time_t now;

	time(&now);
	return now - lastio;
};

int SMDI::setMsgWaiting(char *target)
{
	char sbuf[40];
	int status;

	sprintf(sbuf, "OP:MWI %s!%c", target, SMDI_CTRL_D);
	ENTER_CRITICAL
	status = SendMsgWaiting(sbuf);
	LEAVE_CRITICAL
	return status;
}

int SMDI::clrMsgWaiting(char *target)
{
	char sbuf[40];
	int status;

	sprintf(sbuf, "RMV:MWI %s!%c", target, SMDI_CTRL_D);
	ENTER_CRITICAL
	status = SendMsgWaiting(sbuf);
	LEAVE_CRITICAL
	return status;
}

void SMDI::Run(void)
{
	char *cp;
	int desk;
	int port;
	char type;
	char *cid;
	char *fwd; 
	char *p1, *p2;
	int ctype;

	for(;;)
	{
		cp = Readline();
		if(!cp)
		{
			OnExit();
			continue;
		}

		while(*cp == ' ' || *cp == '\t' || *cp == '\n')
			++cp;

		if(!*cp)
			continue;

		if(!strncmp(cp, "MD ", 3))
		{
			
			desk = atoi(cp + 3);
			cp = strchr(cp + 3, ' ');
			port = atoi(++cp);
			cp = strchr(cp, ' ');
			ctype = 0;
			p1 = strtok(cp + 2, " \t\n");
			p2 = strtok(NULL, " \t\n");
			if(p2)
			{
				if(!*p2)
					p2 = NULL;
			}
			if(p1)
			{
				if(!*p1)
					p1 = NULL;
			}
			cid = fwd = NULL;
			switch(*++cp)	
			{
			case 'D':
				ctype = SMDI_DIRECT;
				cid = p1;
				break;
			case 'A':
				ctype = SMDI_FWDALL;
				fwd = p1;
				cid = p2;
				break;
			case 'B':
				ctype = SMDI_FWDBUSY;
				fwd = p1;
				cid = p2;
				break;
			case 'N':
				ctype = SMDI_FWDNA;
				fwd = p1;
				cid = p2;
				break;
			}
			if(!ctype)
				continue;

			OnRing(desk, port, ctype, cid, fwd);
			continue;
		}

		if(!strncmp(cp, "MWI ", 4))
		{
			OnStat(strtok(cp + 4, " \t"));
			continue;
		}
	}		
}
