// Copyright (C) 1999 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of tdof.
// 
// The exception is that, if you link the tdof ixj library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the tdof ixj library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released by OST under the 
// name tdof.  If you copy code from other releases into a copy of
// tdof, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for tdof, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#ifndef	__APE_IXJ_H__
#define	__APE_IXJ_H__

#ifndef	__APE_THREAD_H__
#include <APE/thread.h>
#endif

typedef	enum
{
	IXJ_G723_63,
	IXJ_G723_53,
	IXJ_TS85,
	IXJ_TS48,
	IXJ_TS41,
	IXJ_G728,
	IXJ_G729,
	IXJ_ULAW,
	IXJ_ALAW,
	IXJ_LINEAR16,
	IXJ_LINEAR8,
	IXJ_WSS
}	ixjcodec_t;

typedef enum
{
	IXJ_POTS_PORT,
	IXJ_PSTN_PORT,
	IXJ_SPEAKER_PORT,
	IXJ_HANDSET_PORT,
	IXJ_INVALID_PORT
}	ixjport_t;

#define	IXJ_TERM_DIGIT_0	0x00000001
#define	IXJ_TERM_DIGIT_1	0x00000002
#define	IXJ_TERM_DIGIT_2	0x00000004
#define	IXJ_TERM_DIGIT_3	0x00000008
#define	IXJ_TERM_DIGIT_4	0x00000010
#define IXJ_TERM_DIGIT_5	0x00000020
#define	IXJ_TERM_DIGIT_6	0x00000040
#define	IXJ_TERM_DIGIT_7	0x00000080
#define	IXJ_TERM_DIGIT_8	0x00000100
#define	IXJ_TERM_DIGIT_9	0x00000200
#define	IXJ_TERM_DIGIT_STAR	0x00000400
#define	IXJ_TERM_DIGIT_POUND	0x00000800

#define	IXJ_TERM_EXPIRED	0x10000000

class IXJService : public Semaphore, public Thread
{
private:
	struct timeval expires;
	fd_set inp, out, err;

	IXJService();
	~IXJService()
		{Terminate();};

	void Service(void);
	void Run(void);

	friend class IXJPort;
};	

class IXJPort
{
private:
	static fd_set events, pending, notify;
	static int hiwater;
	static IXJPort *first, *last;
	static Mutex update;
	static int iosync[2];
	static IXJService *callback;

	int dsptype;
	int version;
	long frametimer;
	int framesize;

	unsigned long termcode, termmask;
	bool offhook;
	bool recording, playing;
	bool initial;
	bool ready;
	int fd;
	IXJPort *next, *prev;
	struct timeval timer;

	void postUpdate(void);
	
	friend class IXJService;

protected:
	virtual void ioPending(void) = 0;
	virtual void ioInitial(void) = 0;
	virtual void ioNotify(void) = 0;
	virtual void ioWinking(void) = 0;
	virtual void ioRinging(void) = 0;
	virtual void ioCallerId(char *buf) = 0;
	virtual void ioDigit(char digit) = 0;
	virtual void ioTerminate(void)
		{setIdle();};

	void ioExpired(void);
	void ioEvent(void);
	void setTimer(long msec);
	void endTimer(void);
	long getTimer(void);
	void Disable(void);	// * default destructor

	void setNotify(void);
	void setPending(bool mode);
	int RecordFrame(void *buf, size_t len);
	int PlayFrame(void *buf, size_t len);
	void RecordStop(void);
	void PlayStop(void);
	
public:
	IXJPort(char *devname);
	virtual ~IXJPort()
		{Disable();};

	void Enable(void);		//* adds to connect map, etc
	ixjport_t setPortUsed(ixjport_t port);
	ixjport_t getPortUsed(void);
	int setCodec(ixjcodec_t codec);

	void setHook(bool mode);
	void setIdle(void);		// reset to idle
	unsigned long getTerminate(void);
	void setTerminate(unsigned long flag);
	unsigned long PlayMemory(unsigned char *buf, size_t len, unsigned long termcode);
	unsigned long RecMemory(unsigned char *buf, size_t len, unsigned long termcode);
	unsigned long PlayFile(int fd, size_t maxlen, unsigned long termcode);
	unsigned long RecFile(int fd, size_t maxlen, unsigned long termcode);
	
	int getDSPType(void)
		{return dsptype;};

	int getDSPVersion(void)
		{return version;};

	long getFrameTimer(void)	// millisec interval of a frame
		{return frametimer;};

	int getFrameSize(void)		// i/o size for a frame
		{return framesize;};
};

// simple demo functions

#endif

