// Copyright (C) 1999 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of tdof.
// 
// The exception is that, if you link the tdof ixj library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the tdof ixj library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released by OST under the 
// name tdof.  If you copy code from other releases into a copy of
// tdof, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for tdof, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include "ixj.h"

IXJService::IXJService() : 
Semaphore(), Thread((Semaphore *)this)
{
	FD_ZERO(&inp);
	FD_ZERO(&out);
	FD_ZERO(&err);
}

void IXJService::Service(void)
{
	IXJPort *port;
	long timer = 3600000l;	// 1 hour idle....
	long expires;
	char buf[1];
	struct timeval timeout;
	int count;

	++IXJPort::update;	// lock the linked list
		
	// flush out the pipe

	while(1 == read(IXJPort::iosync[0], &buf, 1))
		;

	port = IXJPort::first;
	while(port)
	{
		if(port->initial)
		{
			port->ioInitial();
			port->initial = false;
			port = port->next;
			continue;
		}	

		if(FD_ISSET(port->fd, &inp))
			port->ioPending();

		if(FD_ISSET(port->fd, &err))
			port->ioEvent();

		if(FD_ISSET(port->fd, &IXJPort::notify))
		{
			FD_CLR(port->fd, &IXJPort::notify);
			port->ioNotify();
		}

		if(!expires)
		{
			port->endTimer();
			port->ioExpired();
		}
		expires = port->getTimer();
		if(expires > 0)
			if(expires < timer)
				timer = expires;
	
	}
	--IXJPort::update;	// unlock the linked list

	memcpy(&inp, &IXJPort::pending, sizeof(inp));
	memcpy(&err, &IXJPort::events, sizeof(err));
	timeout.tv_sec = timer / 1000;
	timeout.tv_usec = (timer % 1000) * 1000;
	select(IXJPort::hiwater, &inp, &out, &err, &timeout);
}

void IXJService::Run(void)
{
	setCancel(THREAD_CANCEL_DEFERRED);

	for(;;)
	{
		Service();
		Yield();
	}
}
				
