//================================================================
//  drawapp.cxx:     Source file for simple draw V application
//  Copyright (C) 1995  Bruce E. Wampler
//================================================================
//  Files required for draw application:
//      drawapp.h:      Header for the draw app
//      drawapp.cxx:   	Source code for draw app class
//	drawcmdw.h:	Header for draw command window class
//	drawcmdw.cxx:	Source code for draw command window
//	drawcnv.h:	Header for draw canvas class
//	drawcnv.cxx:	Sorce for draw canvas class
//
#include "drawapp.h"	// our header

//==================>>> drawApp::NewAppWin <<<====================
  vWindow* drawApp::NewAppWin(vWindow* win, char* name, int h, int w,
    vAppWinInfo* winInfo)
  {
    // Create a new Draw window

    vWindow* thisWin = win;		// local copy to use
    vAppWinInfo* awinfo = winInfo;

    if (!thisWin)			// need to new a window
      {
	thisWin = new myCmdWindow(name, h, w);
      }

    if (!awinfo)
	awinfo = new vAppWinInfo(name);

    return vApp::NewAppWin(thisWin, name, h, w, awinfo);
  }

//======================>>> drawApp::Exit <<<=====================
  void drawApp::Exit(void)
  {
    // This is called to close all windows. 

    vApp::Exit();	// easy default behavior
  }

//====================>>> drawApp::CloseAppWin <<<================
  void drawApp::CloseAppWin(vWindow* win)
  {
    // Code to handle close of window (such as saving/closing
    // a file) would go here...

    vApp::CloseAppWin(win);
  }

//***** EVERY V application needs to declare an app instance *****

  static drawApp draw_App("V Draw");	// The instance of the app

//========================>>> AppMain <<<=========================
  int AppMain(int argc, char** argv)
  {
    // Use AppMain to create the main window

    theApp->NewAppWin(0, "V Draw - No Name", 250, 500,0);
    return 0;		// 0 means OK
  }
