//===============================================================
// vWindow.h - vWin class definitions - Windows
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VWINDOW_H
#define VWINDOW_H

#include <v/v_defs.h>
#include <v/vbasewin.h>		// we are derived from vBaseWindow
#include <v/vapp.h>		// we are a friend of the app class
#include <v/vcanvas.h>		// need for SetWinCursor

//#include <v/vmenu.h>	// so we can get to GetMenuThis

    // We will allow a Button Bar and a Status Bar in Windows

    class vPane;

    typedef struct PaneList
      {
	vPane* pane;		// pointer to the pane object
	PaneList *nextPL;	// next pane
      } PaneList;

    class vWindow : public vBaseWindow
      {

	friend class vPane;
        friend class vMenuPane;
	friend class vCanvasPane;

      public:		//---------------------------------------- public
	vWindow(char *name = "+", int height = 0, int width = 0,
	  WindowType wintype = WINDOW);	// Constructor

        vWindow(const vWindow&);		// Copy Constructor

	virtual ~vWindow();		// Destructor

	// Methods to Override

	virtual void KeyIn(vKey keysym, unsigned int shift);  // KeyIn method
	virtual void MenuCommand(ItemVal id);
	virtual void WindowCommand(ItemVal id, ItemVal retval, CmdType ctype);

	// Utility Methods

	virtual void AddPane(vPane* add_pane);	// add a pane to the window
	virtual int GetValue(ItemVal id);
  	virtual void RaiseWindow(void);	// raise this window
	virtual void SetValue(ItemVal id, int val, ItemSetType setType);
	virtual void SetString(ItemVal id, char* str);
	virtual void SetValueAll(ItemVal id, int val, ItemSetType setType);
	virtual void SetStringAll(ItemVal id, char* str);
	virtual void SetTitle(char* title);
	void ShowPane(vPane* wpane, int OnOrOff);

	virtual void GetPosition(int& left, int& top, int& right, int& bottom);
	virtual void SetPosition(int left, int top);

	// Other Methods

	virtual void CloseWin(void);	// callback for close button

		// Internal Methods
	long MdiWindowProc(HWND hWnd, UINT message, 
		WPARAM wParam, LPARAM lParam);

      protected:	//--------------------------------------- protected

	int _WinHeight;		// height of draw window
	int _WinWidth;		// width of draw window

      private:		//--------------------------------------- private

	void initialize(void);
	void SetWinCursor(VCursor vcursor);

	static int _numWindows;	// how many total windows are up

	static vWindow* _WinList;	// all windows
	static HWND _curWin;
        static HWND _prevWin;


	PaneList* _paneList;		// panes for this window

        vCanvasPane* _canvasPane;	// our one canvas pane

	vWindow* _NextWin;		// link to next window

	void KeyInEV(unsigned int keycode, int map, int extended);
	int _shiftKeyDown;
	int _ctrlKeyDown;
	
	HMENU _menuBar;
	int _WindowMenuIndex;		// number of the Windows menu
	int _justActivated;		// for mouse control
	int _mouseDown;			// to track mouse up/down
        HCURSOR _cursor;		// mouse cursor

      };
#endif
