//===============================================================
// vcolor.cxx: vColor class for drawing - X11R5
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#include <v/vapp.h>
#include <v/vcolor.h>

    // Define 16 standard colors for use by everyone

    vColor vStdColors[16] =
      {
	vColor( 0, 0, 0),       // vC_Black
        vColor( 255, 0, 0),     // vC_Red
        vColor( 127, 0, 0),     // vC_DimRed
        vColor( 0, 255, 0),     // vC_Green
        vColor( 0, 127, 0),     // vC_DimGreen
        vColor( 0, 0, 255),     // vC_Blue
        vColor( 0, 0, 127),     // vC_DimBlue
        vColor( 255, 255, 0),   // vC_Yellow
        vColor( 127, 127, 0),   // vC_DimYellow
        vColor( 255, 0, 255),   // vC_Magenta
        vColor( 127, 0, 127),   // vC_DimMagenta
        vColor( 0, 255, 255),   // vC_Cyan
        vColor( 0, 127, 127),   // vC_DimCyan
        vColor( 63, 63, 63),    // vC_DarkGray
        vColor( 127, 127, 127), // vC_MedGray
        vColor( 255, 255, 255)  // vC_White
//	{ 0, 0, 0},	// vC_Black
//	{ 255, 0, 0},	// vC_Red
//	{ 127, 0, 0},	// vC_DimRed
//	{ 0, 255, 0},	// vC_Green
//	{ 0, 127, 0},	// vC_DimGreen
//	{ 0, 0, 255},	// vC_Blue
//	{ 0, 0, 127},	// vC_DimBlue
//	{ 255, 255, 0},	// vC_Yellow
//	{ 127, 127, 0},	// vC_DimYellow
//	{ 255, 0, 255},	// vC_Magenta
//	{ 127, 0, 127},	// vC_DimMagenta
//	{ 0, 255, 255},	// vC_Cyan
//	{ 0, 127, 127},	// vC_DimCyan
//	{ 63, 63, 63},	// vC_DarkGray
//	{ 127, 127, 127},	// vC_MedGray
//	{ 255, 255, 255}	// vC_White
      };

    char* vColorNames[16] =
	{
	"Black", "Red", "Dim Red", "Green", "Dim Green", "Blue",
	"Dim Blue", "Yellow", "Dim Yellow", "Magenta", "Dim Magenta",
	"Cyan", "Dim Cyan", "Dark Gray", "Med Gray", "White"
	};

#include <stdio.h>
//=======================>>> vColor::vColor <<<===========================
  vColor::vColor(unsigned int rd, unsigned int gr, unsigned int bl)
  {
    _r = (unsigned char) rd;
    _g = (unsigned char) gr;
    _b = (unsigned char) bl;
    _pixel = 0; _mapped = 0;
  }

//=======================>>> vColor::Set <<<===========================
  vColor::Set(unsigned int rd, unsigned int gr, unsigned int bl)
  {
    _r = (unsigned char) rd;
    _g = (unsigned char) gr;
    _b = (unsigned char) bl;
    MapColor();
  }

//=======================>>> vColor::Set <<<===========================
  vColor::Set(vColor& c)
  {
    _r = c.r();
    _g = c.g();
    _b = c.b();
    MapColor();
  }

//=======================>>> vColor::SetR <<<===========================
  void vColor::SetR(unsigned int rd)
  {
    _r = (unsigned char) rd;
    MapColor();
  }

//=======================>>> vColor::SetG <<<===========================
  void vColor::SetG(unsigned int gr)
  {
    _g = (unsigned char) gr;
    MapColor();
  }

//=======================>>> vColor::SetB <<<===========================
  void vColor::SetB(unsigned int bl)
  {
    _b = (unsigned char) bl;
    MapColor();
  }

//=======================>>> vColor::MapColor <<<===========================
  void vColor::MapColor()
  {
    // This will normally be used only internally. There is some
    // chance a user overriding a drawing canvas will need to
    // know about this method. The purpose of MapColor (and IsMapped)
    // is to map the V RGB value to whatever internal value the host
    // system requires. In the case of X, this is an X Pixel, which
    // is really a long index into the X display's colormap. Rather
    // than mapping the RGB to a Pixel every time, this will happen
    // only when the color is use to change a brush or font or something.
    // Then the Pixel value can be used directly for X. This mapping
    // should only have to be done whenever a change happens, and
    // the methods that allow changes are the ones to use MapColor.
    // It is harmeless (other than inefficient) to MapColor when it
    // is not needed. IsMapped returns true if the color has already
    // been mapped. This need for mapping is really why vColor is
    // real class rather than a simple struct. The act of setting
    // a new color also causes the color to be mapped.

    XColor xc;

    // Convert from 0-255 scale of V to 0-65535 scale of X
    xc.red = _r * 256;
    xc.green = _g * 256;
    xc.blue = _b * 256;
    xc.flags = DoRed | DoBlue | DoGreen;
    xc.pixel = 0;

    // Now, map the RGB to a Pixmap index (if color!)

    if (theApp->Xdepth() <= 1 ||
	!XAllocColor(theApp->display(), theApp->Xcolormap(), &xc))
      {
	if (_r == 0 && _g == 0 & _b == 0)	// Really black
	    _pixel = XBlackPixel(theApp->display(),0);
	else
	    _pixel = XWhitePixel(theApp->display(),0);
      }
    else
      {
	_pixel = xc.pixel;
      }

    _mapped = 1;
  }
