//===============================================================
// vx2vkey.cxx - routines for converting V key codes
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#include <v/v_defs.h>
#include <v/vkeys.h>
#include <v/vx2vkey.h>
#include <X11/keysym.h>

#ifndef XK_KP_Home		// X11R5 vs. X11R6
#define XK_KP_Home XK_Home
#define XK_KP_Left XK_Left
#define XK_KP_Up XK_Up
#define XK_KP_Right XK_Right
#define XK_KP_Down XK_Down
#define XK_KP_Page_Up XK_Prior
#define XK_KP_Page_Down XK_Next
#define XK_KP_End XK_End
#define XK_KP_Insert XK_Insert
#define XK_KP_Delete XK_Delete
#endif

  static vKey XtoV[] =
  {
    XK_BackSpace, VK_BackSpace,  XK_Tab, VK_Tab,  XK_Linefeed, VK_Linefeed,
    XK_Return, VK_Return,  XK_Pause, VK_Pause,  XK_Escape, VK_Escape,
    XK_Delete, VK_Delete,  XK_Home, VK_Home,  XK_Left, VK_Left,
    XK_Up, VK_Up,  XK_Right, VK_Right,  XK_Down, VK_Down,  XK_Prior, VK_Page_Up,
    XK_Next, VK_Page_Down,  XK_End, VK_End,  XK_Num_Lock, VK_Num_Lock,
    XK_KP_Enter, VK_KP_Enter,  XK_KP_Home, VK_KP_Home,  XK_KP_Left, VK_KP_Left,
    XK_KP_Up, VK_KP_Up,  XK_KP_Right, VK_KP_Right,  XK_KP_Down, VK_KP_Down,
    XK_KP_Page_Up, VK_KP_Page_Up,  XK_KP_Page_Down, VK_KP_Page_Down,
    XK_KP_End, VK_KP_End,  XK_KP_Insert, VK_KP_Insert,  XK_KP_Delete, VK_KP_Delete,
    XK_KP_Equal, VK_KP_Equal,  XK_KP_Multiply, VK_KP_Multiply,
    XK_KP_Add, VK_KP_Add,  XK_KP_Subtract, VK_KP_Subtract,
    XK_KP_Decimal, VK_KP_Decimal,  XK_KP_Divide, VK_KP_Divide,
    XK_KP_0, VK_KP_0,  XK_KP_1, VK_KP_1,  XK_KP_2, VK_KP_2,  XK_KP_3, VK_KP_3,
    XK_KP_4, VK_KP_4,  XK_KP_5, VK_KP_5,  XK_KP_6, VK_KP_6,  XK_KP_7, VK_KP_7,
    XK_KP_8, VK_KP_8,  XK_KP_9, VK_KP_9,  XK_F1, VK_F1,  XK_F2, VK_F2,
    XK_F3, VK_F3,  XK_F4, VK_F4,  XK_F5, VK_F5,  XK_F6, VK_F6,  XK_F7, VK_F7,
    XK_F8, VK_F8,  XK_F9, VK_F9,  XK_F10, VK_F10,  XK_F11, VK_F11,  XK_F12, VK_F12,
  
    // The following are modifer keys pressed by themselves
  
    XK_Shift_L, VK_Shift,  XK_Shift_R, VK_Shift,  XK_Control_L, VK_Control,
    XK_Control_R, VK_Control,  XK_Caps_Lock, VK_Caps_Lock,
    XK_Alt_L, VK_Alt,  XK_Alt_R, VK_Alt, 0, 0
  };


//===============================>>> MapXtoVkey <<<================================
  vKey MapXtoVkey(unsigned int Xkey, unsigned int& shift)
  {
    // Map an X Window System keyvalue to the internal code used by V

    unsigned int tmp;
    vKey vtmp;

    if (Xkey > 0 && Xkey <= '~')	// Normal ascii character
      {
	if (shift == 0)			// no ctrl or alt or shift, so return
	    return Xkey;

	if (shift == VKM_Shift)		// only shifted - kill the flag
	  {
	    shift = 0;			// kill the shift flag
	    if (Xkey == XK_Tab)
		return VK_BackTab;	// special case
	    return Xkey;		// return actual value
	  }
	else if (shift == VKM_Ctrl || shift == (VKM_Ctrl+VKM_Shift))
	// control-X or ctrl-shift-X
	  {
	    if (Xkey >= '@' && Xkey <= '_')
	      {
		shift = 0;		// kill the shift flag
		vtmp = Xkey - '@';	// normal range
	      }
	    else if (Xkey >= '`' && Xkey <= '~')
	      {
		shift = 0;		// kill the shift flag
		vtmp = Xkey - '`';	// normal range
	      }
	    else
		vtmp = Xkey;		// just let it map;

	    return vtmp;
	  }
	// else it is combination of Alt, Shift, Ctrl
	return Xkey;
      }

    // To here, then need to map
    for (int ix = 0 ; XtoV[ix] != 0 ; ix += 2 )
      {
	// Search the XtoV table
	if (XtoV[ix] == Xkey)
	    return XtoV[ix+1];
      }
    return VK_None;
  }
