//=======================================================================
//  vtcmdwin.cxx - testCmdWindow class
//  Copyright (C) 1995,1996  Bruce E. Wampler
//
//  This program is part of the V C++ GUI Framework example programs.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  (see COPYING) along with this program; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=======================================================================

#include <v/vcanvas.h>	// for Cursors
#include <v/vcolor.h>
#include <v/vicon.h>
#include <v/vutil.h>
#include <v/vfontsel.h>
#include <v/vfont.h>
#include <v/vprinter.h>

#include "vtcmdwin.h"

    static char mess[] = "[A] Is this a good test of text?\n";
    static int filterIndex = 0;
    static char* filter[] =
      {
	"*",
	"*.txt",
	"*.c *.cxx *.h",
	0
      };

#define copy_width 28
#define copy_height 12
static unsigned char copy_bits[] = {
   0x00, 0x00, 0xff, 0x01, 0xf8, 0x0f, 0x01, 0x01, 0x08, 0x08, 0x09, 0x01,
   0x08, 0x08, 0x19, 0x01, 0xc8, 0xff, 0x3f, 0x01, 0xc8, 0xff, 0x7f, 0x01,
   0xc8, 0xff, 0x3f, 0x01, 0x08, 0x08, 0x19, 0x01, 0x08, 0x08, 0x09, 0x01,
   0x08, 0x08, 0x01, 0x01, 0x08, 0x08, 0xff, 0x01, 0xf8, 0x0f, 0x00, 0x00};

    static vIcon copyIcon(&copy_bits[0], copy_height, copy_width);

#define DRAW_BRUCE
#ifdef DRAW_BRUCE
#include "bruce.vbm"	// bruce picture bitmap
    static vIcon bruceIcon(&bruce_bits[0], bruce_height, bruce_width,8);
#else
#define color_width 16
#define color_height 24
static unsigned char color_bits[] = {
	2,		// 3 colors (offset by 1)
	255,0,0,	// 0 -> red
	0,255,0,	// 1 -> green
	0,0,255,	// 2 -> blue
	// a rgb "flag", 3 16x8 rows of each color
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// RRRRRRRRRRRRRRRR
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// RRRRRRRRRRRRRRRR
	0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,	// RRRRRRRRRRBBBBBR
	0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,	// RRRRRRRRRRBBBBBR
	0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,	// RRRRRRRRRRBBBBBR
	0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,	// RRRRRRRRRRBBBBBR
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// RRRRRRRRRRRRRRRR
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// RRRRRRRRRRRRRRRR
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	// GGGGGGGGGGGGGGGG
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	// GGGGGGGGGGGGGGGG
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	// GGGGGGGGGGGGGGGG
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	// GGGGGGGGGGGGGGGG
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	// GGGGGGGGGGGGGGGG
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	// GGGGGGGGGGGGGGGG
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	// GGGGGGGGGGGGGGGG
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	// GGGGGGGGGGGGGGGG
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,	// BBBBBBBBBBBBBBBB
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,	// BBBBBBBBBBBBBBBB
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,	// BBBBBBBBBBBBBBBB
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,	// BBBBBBBBBBBBBBBB
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,	// BBBBBBBBBBBBBBBB
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,	// BBBBBBBBBBBBBBBB
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,	// BBBBBBBBBBBBBBBB
	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2		// BBBBBBBBBBBBBBBB
      };

    static vIcon colorIcon(&color_bits[0], color_height, color_width,8);
#endif

#define c24_height 15
#define c24_width 8
    static unsigned char c24_bits[] = {
     255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0, //RRRRRRRR
     255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,0,255,0,0,255,0, //RRRRRRGG
     255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,0,255,0,0,255,0, //RRRRRRGG
     255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,0,255,0,0,255,0, //RRRRRRGG
     255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0, //RRRRRRRR
     0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0, //GGGGGGGG
     0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0, //GGGGGGGG
     0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0, //GGGGGGGG
     0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0, //GGGGGGGG
     0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0, //GGGGGGGG
     0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255, //BBBBBBBB
     0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255, //BBBBBBBB
     0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255, //BBBBBBBB
     0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255, //BBBBBBBB
     0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255, //BBBBBBBB
     0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255  //BBBBBBBB
     };
    static vIcon c24Icon(&c24_bits[0], c24_height, c24_width,24);

    int copy_sens = 0;

//#########################################################################

    static char sub[] = "SubA";
    static char title[] = "A Title";
    static char blabel[] = "A New Label";

#define M_SimpleWin 11
#define M_YNDialog 12
#define M_Dialog 13
#define M_CheckMe 14
#define M_CopySens 15
#define M_ShowList 16
#define M_ChangeButton 17
#define M_ModalDialog 18
#define M_TextIn 19
#define M_List 20
#define M_Message 21


#define M_ChgTitle 30
#define M_ChgAppTitle 31
#define M_Reply 32
#define M_AttrMessage 33
#define M_RevMessage 34
#define M_CenterCursor 35
#define M_SubMenu 37
#define M_HideCursor 38
#define M_ShowCursor 39
#define m_ChangeCursor 40


#define m_Hon 41
#define m_Hoff 42
#define m_Von 43
#define m_Voff 44
#define m_ScrollSub 45
#define m_HideStat 46
#define m_ShowStat 47
#define m_HideCmd 48
#define m_ShowCmd 49
#define m_HideCnv 50
#define m_ShowCnv 51
#define m_font 52
#define m_printText 53
#define M_DrawIcon 54

#define m_Timer 60
#define m_CurTime 61

//	Sample Menu Item Definition
//	{"x", M_x, isSens, notChk, noKeyLbl, noKey, noSub},

    vMenu WindowSubMenu[] =
      {
	{"Center Cursor", M_CenterCursor,isSens, notChk, noKeyLbl, noKey, noSub},
	{"Change Cursor", m_ChangeCursor,isSens, notChk, noKeyLbl, noKey, noSub},
	{"Change Title", M_ChgTitle, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Change App Title", M_ChgAppTitle, isSens, notChk, noKeyLbl, noKey, noSub},
	{"CheckMe", M_CheckMe, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Copy Sensitive", M_CopySens, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Hide Cursor", M_HideCursor,isSens, notChk, noKeyLbl, noKey, noSub},
	{"Draw Icon",M_DrawIcon,isSens,notChk,noKeyLbl,noKey,noSub},
	{"Notice from vApp", 901, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Show Cursor", M_ShowCursor,isSens, notChk, noKeyLbl, noKey, noSub},
	{"Show Window List", M_ShowList, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Shift Window",903, isSens, notChk, noKeyLbl, noKey, noSub},
	{"vWindow", M_SimpleWin, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Raise First Window", 902, isSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };

    vMenu ScrollMenu[] =
      {
	{"Show HScroll", m_Hon, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Hide HScroll", m_Hoff, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Show VScroll", m_Von, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Hide VScroll", m_Voff, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Hide Status", m_HideStat, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Show Status", m_ShowStat, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Hide CmdBar", m_HideCmd, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Show CmdBar", m_ShowCmd, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Hide Canvas", m_HideCnv, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Show Canvas", m_ShowCnv, isSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };

    vMenu TestMenu[] =
      {
	{"&Dialog", M_Dialog, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Hide/Show",m_ScrollSub, isSens,notChk,noKeyLbl,noKey, ScrollMenu},
	{"List", M_List, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Modal Dialog", M_ModalDialog, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Misc Tests", M_SubMenu, isSens, notChk, noKeyLbl, noKey, WindowSubMenu},
	{"Set Font", m_font, isSens, notChk,noKeyLbl, noKey, noSub},
	{"Print Text", m_printText, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Text In", M_TextIn, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Reply", M_Reply, isSens, notChk, noKeyLbl, noKey, noSub},
	{"YN Dialog", M_YNDialog, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Timer", m_Timer, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Current Time", m_CurTime, isSens, notChk, noKeyLbl, noKey, noSub},
	{"CheckMe", M_CheckMe, isSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };

    vMenu ShortFile[] =
      {
	{"&New", M_New, isSens, notChk, noKeyLbl, noKey, noSub},
	{"E&xit", M_Exit, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
      };

    vMenu FileMenu[] =
      {
	{"&New", M_New, isSens, notChk, noKeyLbl, noKey, noSub},
	{"&Open", M_Open, isSens, notChk, noKeyLbl, noKey, noSub},
	{"&Save", M_Save, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Save &As", M_SaveAs, notSens, notChk, noKeyLbl, noKey, noSub},
#ifdef vDEBUG
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"&Debug", M_SetDebug, isSens, notChk, noKeyLbl, noKey, noSub},
#endif
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"&Close",M_Close, isSens, notChk, noKeyLbl, noKey, noSub},
	{"E&xit", M_Exit, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
      };

    vMenu EditMenu[] =
      {
	{"Cut", M_Cut, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Copy", M_Copy, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Paste", M_Paste, notSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
      };

    vMenu StandardMenu[] =
      {
	{"&File", M_File, isSens, notUsed, notUsed, noKey, &FileMenu[0]},
		// the File menu
	{"&Edit", M_Edit, isSens, notUsed, notUsed, noKey, &EditMenu[0]},
		// the Edit menu
	{"&Test", M_Test, isSens, notUsed, notUsed, noKey, &TestMenu[0]},
		// the Test menu
	{NULL}
      };

  
#define vC_Size 8

    CommandObject CommandBar[] =
      {
//	{C_Button, M_Copy, M_Copy, "Copy", NoList,CA_None,notSens,NoFrame, 0, 0},
	{C_IconButton, M_Copy, M_Copy, "Copy", &copyIcon,CA_None,notSens,NoFrame, 0, 0},
	{C_Button, M_Clear, M_Clear, "Clear", NoList,CA_None,isSens,NoFrame, 0, 0},
	{C_Button, M_Message, M_Message, "Message", NoList,CA_None,isSens,NoFrame, 0, 0},
	{C_Button, M_RevMessage, M_RevMessage, "RevMsg", NoList,CA_None,isSens,NoFrame, 0, 0},
	{C_Button, M_ChangeButton, M_ChangeButton, "Change Me", NoList,CA_None,isSens,NoFrame, 0, 0},

#include <v/vcb2x4.h>

	{C_ColorButton, M_Exit, M_Exit, "Exit", &vStdColors[vC_Red],CA_None,isSens,NoFrame, 0, 0},
	{C_Slider, 888, 50, "",NoList,CA_Horizontal | CA_Small ,isSens,NoFrame, 0, 0},
	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };

    CommandObject CommandBar2[] =
      {
	{C_Button, M_New, M_New, "New", NoList,CA_None,isSens,NoFrame, 0, 0},
        {C_Button, M_Close, M_Close, "Close", NoList,CA_None,isSens,NoFrame, 0, 0},
	{C_Button, M_AttrMessage, 0, "Attr Message", NoList,CA_None,isSens,NoFrame,0,0},
	{C_Button, M_Exit, M_Exit, "Exit", NoList,CA_None,isSens,NoFrame, 0, 0},
	{C_Slider, 889, 50, "",NoList,CA_Horizontal ,isSens,NoFrame, 0, 0},
	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };

    vStatus StatBar[] =
      {
	{" Time: ", 305, CA_NoBorder, isSens, 0},
	{" 0:00:00 AM  00/00/00 ",306, CA_None, isSens, 0},
	{" Color:", 302, CA_NoBorder, isSens, 0 },
	{" Black ", 304, CA_None, isSens, 70},
	{NULL,0,0,0,0}
      };

    char text_buff[256];	// big buffer for text

    CommandObject textInList[] =
      {
	{C_Label, 1, 1, "TI",NoList,
		CA_MainMsg,isSens,NoFrame, 0,0},
	{C_TextIn, 2, 2, "Default Test Text", NoList,
		CA_None,isSens,NoFrame,0,1},
	{C_Button, M_OK, M_OK, " OK ", NoList,CA_DefaultButton,
		isSens,NoFrame,0,2},
	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };

    CommandObject ModalList[] =
      {
	{C_Label, 10, 10, "YND",
		 NoList, CA_MainMsg, isSens, NoFrame, 0,0},
	{C_Label, 99, 0, "Sample Label", NoList, CA_None,isSens,NoFrame, 10,0},


	{C_Blank, 11, 0, "     ", NoList, CA_None,isSens,NoFrame, 0,10},
	{C_Button, M_OK, M_OK, " OK ", NoList,
		CA_DefaultButton, isSens, NoFrame, 11, 10},
	{C_Button, 14, M_No, " No ", NoList,CA_None,isSens,NoFrame, M_OK, 10},
	{C_Button, M_Cancel, M_Cancel, " Cancel ", NoList,
		CA_None,isSens,NoFrame,14, 10},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };

    char* comboList[] =
      {
	"Bruce",
	"Katrina",
	"Risa",
	"Van",
	"Chaco and Sushi",
	0
      };

    char* testList[] =
      {
	"First 0",
	"Item 1",
	"Item 2",
	"Item 3",
	"Item 4",
	"Item 5",
	"Item 6",
	"Item 7",
	"Item 8",
	"Item 9",
	"Item 10",
	"Item 11",
	"Item 12",
	"Item 13",
	"Item 14 (last)",
	0
      };

    static VCursor curCursor = VC_IBar;

    static char* valList[] = {"Value A", "Value B", "A Long Value", "Last Value", 0};

    static int minMaxStep[3] = {-10, 10, 2};

    CommandObject ListList[] =
      {
	{C_Label, 210, 210, "List Test",
		 NoList, CA_MainMsg, isSens, 0,0},
	{C_List, 200, 0, "A List", (void*)testList,
		 CA_None,isSens,NoFrame,0,210},
	{C_ComboBox,201,2,"ComboBox",(void*)comboList,
		 CA_Simple,isSens,NoFrame,200,210},

	{C_Spinner, 50,0,"Spinner", (void*)valList,CA_Text,isSens,NoFrame, 200,201},

	{C_Spinner, 51,32, "Spinner", NoList,CA_None,isSens,NoFrame, 200,50},
	{C_Spinner, 52,-2, "Spinner", (void*)minMaxStep,CA_None,isSens,NoFrame, 51,50},

	{C_Button, M_OK, M_OK, " OK ", NoList,
		CA_DefaultButton, isSens, NoFrame, 0, 200},
	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };

   static long ticks = 0;
   static vFont gfont(vfDefaultFixed);


//====================>>> myTimer::TimerTick <<<====================
  void myTimer::TimerTick()
  {
   ++ticks;
   cmdw->WindowCommand(m_CurTime, m_CurTime, C_Button);			// update clock
  }

//====================>>> testCmdWindow::testCmdWindow <<<====================
  testCmdWindow::testCmdWindow(char* name, int height, int width) :
    vCmdWindow(name, height, width)
  {

    UserDebug1(Constructor,"testCmdWindow::testCmdWindow(%s) Constructor\n",name)

    _timerOn = 0;

    nextWin = 0;
    nextCmdWin = 0;
    curDialog = 0;

    // The "Standard" window will consist of a menubar, a canvas,
    // an optional button bar, and an optional status bar.

    // First, create and add the proper panes to the CmdWindow
    // Note: there must be a correspondint delete in the destructor

    // The Menu Bar
    myMenu = new vMenuPane(StandardMenu);	// the standard menu
    AddPane(myMenu);				// add pane to window

    // The command pane
    myCmdPane = new vCommandPane(CommandBar);
    AddPane(myCmdPane);

    // The command pane
    myCmdPane2 = new vCommandPane(CommandBar2);
    AddPane(myCmdPane2);

    // The Canvas
    myCanvas = new testCanvasPane;		// a new canvas pane
    AddPane(myCanvas);				// add the pane to window

    // The Status Bar
    myStatus = new vStatusPane(StatBar);	// a new status bar
    AddPane(myStatus);				// add pane to window

    // the timer
    _timer = new myTimer(this);


    ShowWindow();
    WindowCommand(m_CurTime, m_CurTime, C_Button);  	// update clock
  }

//====================>>> testCmdWindow::~testCmdWindow <<<====================
  testCmdWindow::~testCmdWindow()
  {
    UserDebug(Destructor,"testCmdWindow::~testCmdWindow() destructor\n")

    if (_timerOn) _timer->TimerStop();
    delete _timer;
    delete myMenu;
    delete myCanvas;
    delete myCmdPane;
    delete myCmdPane2;
    delete myStatus;

  }

//====================>>> testCmdWindow::WindowCommand <<<====================
  void testCmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)
  {

    // route all commands through here - menus and buttons
    char buff[20];

    switch (id)
      {
	case M_New:
	  {
	    // Create and register a new window
	    testCmdWindow* tmp = new testCmdWindow(sub,
		theApp->DefaultHeight(), theApp->DefaultWidth());
	    theApp->NewAppWin(tmp, sub, 100,400);
	    sub[3]++;
	    break;
	  }

	case M_Open:
	  {
	    static char name[100] = "";	// start out with null name
	    vFileSelect fsel(this);	// make an instance

	    int oans = fsel.FileSelect("Open file",name,99,filter,filterIndex);

	    vNoticeDialog fsnote(this);	// make an instance

	    if (oans && *name)
	      {
		SetTitle(name);
		(void)fsnote.Notice(name);
	      }
	    else
		(void)fsnote.Notice("No file name input.");

	    break;
	  }

	case M_Close:		// Close not via close button
	  {
	    theApp->CloseAppWin(this);
	    break;
	  }

	case M_Exit:
	  {
	    theApp->Exit();
	    break;
	  }

	case M_CheckMe:			// check me
	  {
	    ItemVal curval = GetValue(id);
	    SetValue(M_CheckMe,!curval,Checked);
	    if (curval)
		SetString(M_CheckMe,"Check Me");
	    else
		SetString(M_CheckMe,"UnChk Me");
	    break;
	  }

	case M_CopySens:			// Last
	  {
	    copy_sens = !copy_sens;
	    SetValue(M_Copy,copy_sens,Sensitive);
	    break;
	  }


	case M_SimpleWin:
	  {
	    if (nextWin < MAX_WINDOWS)
	      {
		Wins[nextWin] = new vWindow(sub);
		sub[3]++;		// make a new name
		Wins[nextWin]->ShowWindow();
		++nextWin;
	      }
	   break;
	  }
#ifdef vDEBUG
	case M_SetDebug:
	  {
	    vDebugDialog debug(this);
	    debug.SetDebug();
	    break;
	  }
#endif

	case M_YNDialog:
	  {
	    vYNReplyDialog ynd(this);	// make an instance
	    int ans;
	    char ynmsg[] = "YN Dialog - try one.";

	    ans = ynd.AskYN(ynmsg);
	 //   fprintf(stderr,"YN answer value: %d\n",ans);
	    break;
	  }

	case M_ChgTitle:
	  {
	    SetTitle(title);
	    ++title[0];
	    break;
	  }

	case M_ChgAppTitle:
	  {
	    theApp->SetAppTitle(title);
	    ++title[0];
	    break;
	  }

	case M_Reply:
	  {
	    vReplyDialog rp(this);	// make an instance
	    char out[120];
	    char r[100];		// a buffer for reply

	    (void)rp.Reply("Please enter some text.",r,99);

	    vNoticeDialog note(this);	// make an instance

	    if (*r)
	      {
		strcpy(out,"Text was: ");
		strcat(out,r);
		(void)note.Notice(out);
	      }
	    else
		(void)note.Notice("No text input.");

	    break;
	  }

	case M_CenterCursor:		// test cursor motion
	  {
	    int r = myCanvas->GetRows();
	    int c = myCanvas->GetCols();

	    myCanvas->GotoRC(r/2, c/2);
	    break;
	  }

	case M_HideCursor:
  	  {
	    myCanvas->HideTextCursor();
	    break;
	  }

	case M_ShowCursor:
  	  {
	    myCanvas->ShowTextCursor();
	    break;
	  }

	case m_ChangeCursor:		// change canvas cursor
	  {
	    if (curCursor >= VC_LAST)	// change module # of cursors
		curCursor = 1;
	    else
		++curCursor;
	    myCanvas->SetCursor(curCursor);  // Set the cursor
	    break;
	  }

	case m_Hon:
	  {
	    myCanvas->ShowHScroll(1);  // show the h scroll
	    break;
	  }

	case m_Hoff:
	  {
	    myCanvas->ShowHScroll(0);  // hide the h scroll
	    break;
	  }

	case m_Von:
	  {
	    myCanvas->ShowVScroll(1);  // show the v scroll
	    break;
	  }

	case m_Voff:
	  {
	    myCanvas->ShowVScroll(0);  // hide the v scroll
	    break;
	  }

	case m_HideStat:
	  {
	    ShowPane(myStatus,0);
	    break;
	  }

	case m_ShowStat:
	  {
	    ShowPane(myStatus,1);
	    break;
	  }

	case m_HideCmd:
	  {
	    ShowPane(myCmdPane,0);
	    break;
	  }

	case m_ShowCmd:
	  {
	    ShowPane(myCmdPane,1);
	    break;
	  }

	case m_HideCnv:
	  {
	    ShowPane(myCanvas,0);
	    break;
	  }

	case m_ShowCnv:
	  {
	    ShowPane(myCanvas,1);
	    break;
	  }

	case M_Dialog:
	  {
	    if (!curDialog)
	      {
		curDialog = new testDialog(this);
	      }


	    curDialog->ShowDialog("This is a simple modeless dialog.");
	    int l,t,w,h;
	    GetPosition(l,t,w,h);
	    curDialog->SetDialogPosition(l+10,t+h+5);


	    break;
	  }

	case M_List:
	  {
	    vModalDialog ld(this);	// create dynamically
	    ItemVal lid, junk;
	    int lval, cval, vval, ival1, ival2;

	    ld.AddDialogCmds(ListList);
	    ld.SetValue(200,8,Value);	// pre-select 8
	    lid = ld.ShowModalDialog("List Dialog Test.",junk);
	    lval = ld.GetValue(200);
	    cval = ld.GetValue(201);
	    vval = ld.GetValue(50);
    //	    fprintf(stderr,"List Dialog selection: List:%d, Combo: %d, ValBox: %d\n",
      //		 lval, cval, vval);
	    break;
	  }

	case M_Clear:			// clear display
	  {
	    myCanvas->Clear();
	    break;
	  }

	case M_Message:
	  {
	    myCanvas->DrawText(mess);
	    if (++mess[1] > 'Z')	// something new each time
		mess[1] = 'A';
	    break;
	  }

	case M_AttrMessage:
	  {
	    myCanvas->DrawAttrText("Red, ", ChRed);
	    myCanvas->DrawAttrText("Green, ", ChGreen);
	    myCanvas->DrawAttrText("reversed, ",ChReverse);
	    myCanvas->DrawAttrText("and ", ChNormal);
	    myCanvas->DrawAttrText("Blue.\n", ChBlue);
	    break;
	  }

	case M_RevMessage:
	  {
	    myCanvas->DrawAttrText(mess, ChReverse);
	    if (++mess[1] > 'Z')	// something new each time
		mess[1] = 'A';
	    break;
	  }

	case M_ModalDialog:
	  {
	    vModalDialog md(this);	// try this one dynamically...
	    int id, val;

	    md.AddDialogCmds(ModalList);
	    id = md.ShowModalDialog("This is a MODAL dialog.",val);
 //	    fprintf(stderr,"Modal Dialog id: %d, value: %d\n",id, val);
	    break;
	  }

	case M_ShowList:
	  {
	    theApp->ShowList();
	    break;
	  }

	case M_ChangeButton:
	  {
	    SetString(M_ChangeButton,blabel);
	    ++blabel[0];
	    break;
	  }

	case m_font:
	  {
	    vFontSelect fd(this);

	    (void) fd.FontSelect(gfont);
            myCanvas->SetFont(gfont);
	    myCanvas->Clear();
	    myCanvas->DrawText(mess);
	    if (++mess[1] > 'Z')	// something new each time
		mess[1] = 'A';
	    break;
	  }

	case m_printText:
	  {
	    PrintText();
	    break;
	  }

	case M_DrawIcon:
	  {
	    myCanvas->DrawLine(5,30,20,30);
	    myCanvas->DrawIcon(20,30,copyIcon);
	    myCanvas->DrawIcon(80,30,c24Icon);
#ifdef DRAW_BRUCE
	    myCanvas->DrawIcon(120,2,bruceIcon);
#else
	    myCanvas->DrawIcon(120,30,colorIcon);
#endif
	    break;
	  }

	case M_TextIn:
 	  {
	    vModalDialog md(this);	// try this one dynamically...

	    vNoticeDialog txtin(this);

	    int ans, val;

	    md.AddDialogCmds(textInList);
	    ans = md.ShowModalDialog("Enter text.", val);

	    text_buff[0] = 0;

	    (void) md.GetTextIn(2, text_buff, 254);

	    txtin.Notice(text_buff);
	    break;
	  }

	case m_Timer:
	  {

	    if (_timerOn != 0)
	      {
		_timerOn = 0;
		_timer->TimerStop();
	      }
	    else
	      {
		_timerOn = 1;
		_timer->TimerSet(1000);	// 2 second intervals
	      }
	    SetValue(m_Timer,_timerOn,Checked);
	    break;
	  }

	case m_CurTime:
	  {
	    char buff[40];
	    char date[10];
	    vGetLocalTime(buff);
	    vGetLocalDate(date);
	    strcat(buff,"  ");
            strcat(buff,date);
	    SetString(306,buff);
	    break;
	  }

	default:
	  {
	    if (id >= M_Black && id <= M_White)	// A color button
	      {
		_pen.SetColor(vStdColors[val]);
		myCanvas->SetPen(_pen);
		SetString(304,vColorNames[val]);
	      }
	    else
		vCmdWindow::WindowCommand(id, val, cType);
	    break;
	  }
      }
  }

//====================>>> testCmdWindow::PrintText <<<======================
  void testCmdWindow::PrintText()
  {
    // Test what the text will do

    vPrintDC pdc;		// create a printDC object
    vPrinter printer;
    vFont font;
    int x;

    printer.Setup("test.ps");	// setup the printer

    pdc.SetPrinter(printer);	// change to the printer we setup

    if (!pdc.BeginPrinting())	// print to test.ps
	return;

    // Have a valid drawing canvas, so draw a box around paper edges
    for (int pg = 1 ; pg < 3 ; ++pg)	// print 2 pages to test everyting
      {

	vBrush pbrush(0,0,0,vTransparent);	// a transparent brush
	pdc.SetBrush(pbrush);
	if (pg == 1)
	  {
	    pdc.DrawRectangle(36,36, pdc.GetPhysWidth() - 72,
	        pdc.GetPhysHeight() - 72);
	    pdc.SetTranslate(0,36);	// and now leave 1/2 inch at top
	  }
	// since we center the text, we don't
	// need the left margin

	// ----------- Here is the printing test.

	font.SetFontValues(vfDefaultFixed, 10, vfNormal, vfNormal, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "Default Fixed, 10 point, Normal");
	pdc.DrawLine(x, 12, x, 2);
	pdc.DrawText(x,12,"Default Fixed, 10 point, Normal");

	font.SetFontValues(vfDefaultVariable, 10, vfNormal, vfNormal, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "Default Variable, 10 point, Normal");
	pdc.DrawLine(x, 25, x, 15);
	pdc.DrawText(x,25,"Default Variable, 10 point, Normal");

	font.SetFontValues(vfFixed, 10, vfNormal, vfNormal, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "Fixed, 10 point, Normal");
	pdc.DrawLine(x, 40, x, 30);
	pdc.DrawText(x,40,"Fixed, 10 point, Normal");

	font.SetFontValues(vfSerif, 10, vfNormal, vfNormal, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "Serif, 10 point, Normal");
	pdc.DrawLine(x, 55, x, 45);
	pdc.DrawText(x,55,"Serif, 10 point, Normal");

	font.SetFontValues(vfSansSerif, 10, vfNormal, vfNormal, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "SansSerif, 10 point, Normal");
	pdc.DrawLine(x, 70, x, 60);
	pdc.DrawText(x,70,"SansSerif, 10 point, Normal");

	font.SetFontValues(vfSerif, 10, vfItalic, vfNormal, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "Serif, 10 point, Italic");
	pdc.DrawLine(x, 85, x, 75);
	pdc.DrawText(x,85,"Serif, 10 point, Italic");

	font.SetFontValues(vfSerif, 10, vfItalic, vfBold, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "Serif, 10 point, BoldItalic");
	pdc.DrawLine(x, 100, x, 90);
	pdc.DrawText(x,100,"Serif, 10 point, BoldItalic");

	font.SetFontValues(vfSansSerif, 10, vfItalic, vfNormal, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "SansSerif, 10 point, Italic");
	pdc.DrawLine(x, 115, x, 105);
	pdc.DrawText(x,115,"SansSerif, 10 point, Italic");

	font.SetFontValues(vfSansSerif, 10, vfItalic, vfBold, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "SansSerif, 10 point, BoldItalic");
	pdc.DrawLine(x, 130, x, 120);
	pdc.DrawText(x,130,"SansSerif, 10 point, BoldItalic");

	font.SetFontValues(vfFixed, 10, vfItalic, vfNormal, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "Fixed, 10 point, Italic");
	pdc.DrawLine(x, 145, x, 135);
	pdc.DrawText(x,145,"Fixed, 10 point, Italic");

	font.SetFontValues(vfFixed, 10, vfItalic, vfBold, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "Fixed, 10 point, BoldItalic");
	pdc.DrawLine(x, 160, x, 150);
	pdc.DrawText(x,160,"Fixed, 10 point, BoldItalic");

	font.SetFontValues(vfFixed, 20, vfItalic, vfBold, 0);
	pdc.SetFont(font);
	x = GetCenter( pdc, "BIG Fixed, 20 point, BoldItalic");
	pdc.DrawLine(x, 180, x, 160);
	pdc.DrawText(x,180,"BIG Fixed, 20 point, BoldItalic");

	pdc.SetFont(gfont);
	x = GetCenter( pdc, "Current Screen Font");
	pdc.DrawText(x,210,"Current Screen Font");

	font.SetFontValues(vfSansSerif, 24, vfNormal, vfBold, 1);
	pdc.SetFont(font);
	x = GetCenter( pdc, "The End");
	pdc.DrawLine(x, 310, x, 290);
	pdc.DrawText(x,310,"The End");

	pdc.DrawLine(60,72,72,72);
	pdc.DrawIcon(72,72,copyIcon);

	pdc.DrawLine(100,350,110,350);
	pdc.DrawIcon(110,350,bruceIcon);

	pdc.DrawLine(300,350,310,350);
	pdc.DrawIcon(310,350,c24Icon);

	if (pg == 1)
	  {
	    pdc.EndPage();
	    pdc.BeginPage();
	  }
    }

    pdc.EndPrinting();
  }

//====================>>> testCmdWindow::GetCenter <<<======================
  int testCmdWindow::GetCenter(vPrintDC& pdc, char* str)
  {
    // Determine where the X is to center the text str
    // on the page, given a PrintDC

    int width = pdc.TextWidth(str);		// Width of the text
    int paperW = pdc.GetPhysWidth();		// paper width

    int center = (paperW - width) / 2;		// the x start to center!
    if (width > paperW)				// be reasonable
	center = 0;
    return center;
  }
