//
// A Seed Fill Algorithm
// by Paul Heckbert
// from "Graphics Gems", Academic Press, 1990
//

typedef struct {short y, xl, xr, dy;} Segment;
//
// Filled horizontal segment of scanline y for xl<=x<=xr.
// Parent segment was on line y-dy.  dy=1 or -1
//

#define STACKSIZE 8000    // max depth of stack (< 64K DOS SEGMENT)

// push new segment on stack
#define PUSH(Y, XL, XR, DY) \
    if (sp<stack+STACKSIZE && Y+(DY)>=0 && Y+(DY)<=height) \
    {sp->y = Y; sp->xl = XL; sp->xr = XR; sp->dy = DY; sp++;}

// pop segment off stack
#define POP(Y, XL, XR, DY) \
    {sp--; Y = sp->y+(DY = sp->dy); XL = sp->xl; XR = sp->xr;}

#define pixelread(X, Y) \
  (((tmp = _myPicture->GetIndex(X,Y,TransLayer))==-1) \
   ?_myPicture->GetIndex(X,Y,ImageLayer):tmp)
#define pixelwrite(X,Y) (_myPicture->SetIndex,X,Y,TransLayer,fillcolor)
//
// fill: set the pixel at (x,y) and all of its 4-connected neighbors
// with the same pixel value to the new pixel value nv.
// A 4-connected neighbor is a pixel above, below, left, or right of a pixel.
//

//======================>>> myCanvasPane::fill <<<===========================
  void myCanvasPane::fill(int x, int y, int width, int height, 
	int ov, int fillcolor)
  {
    int start, x1, x2, dy = 0;
    int tmp;

    if (fillcolor == ov)		// nothing to do
	return;

    Segment* sp = new Segment[STACKSIZE]; // allocate the stack

    PUSH(y, x, x, 1);			// needed in some cases
    PUSH(y+1, x, x, -1);		// seed segment (popped 1st)

    while (sp > stack)
      {
	// pop segment off stack and fill a neighboring scan line
	POP(y, x1, x2, dy);

	// segment of scan line y-dy for x1<=x<=x2 was previously filled,

	for (x = x1; x >= 0 && pixelread(x, y) == ov; x--)
	    pixelwrite(x, y);
	if (x >= x1) 
	  {
	    for (x++; x<=x2 && pixelread(x, y)!=ov; x++)
		;
	    start = x;
	    if (x > x2)
		continue;
	  } 
	else
	  {
	    start = x+1;
	    if (start<x1) 
		PUSH(y, start, x1-1, -dy);       // leak on left?
	    x = x1+1;
	  }
	do 
	  {
	    for (; x<=width && pixelread(x, y)==ov; x++)
		pixelwrite(x, y);
	    PUSH(y, start, x-1, dy);
	    if (x>x2+1) 
		PUSH(y, x2+1, x-1, -dy);       // leak on right?
	    for (x++; x<=x2 && pixelread(x, y)!=ov; x++)
		;
	    start = x;
	  } 
	while (x<=x2)
	    ;
      }
    delete sp;
  }
