//===============================================================
// vkeys.h - Defintions for V keys
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VKEYS_H
#define VKEYS_H

#define VK_None		0x0	/* no key */

#define VK_BackSpace		0x08
#define VK_Tab			0x09
#define VK_Linefeed		0x0A
#define VK_Return		0x0D
#define VK_Pause		0x13
#define VK_Escape		0x1B
#define VK_Delete		0x7F

#define VK_BackTab		0xFF09

#define VK_Home			0xFF50
#define VK_Left			0xFF51
#define VK_Up			0xFF52
#define VK_Right		0xFF53
#define VK_Down			0xFF54
#define VK_Page_Up		0xFF55
#define VK_Page_Down		0xFF56
#define VK_End			0xFF57

#define VK_Num_Lock		0xFF7F

#define VK_KP_Enter		0xFF0D
#define VK_KP_Home		0xFF95
#define VK_KP_Left		0xFF96
#define VK_KP_Up		0xFF97
#define VK_KP_Right		0xFF98
#define VK_KP_Down		0xFF99
#define VK_KP_Page_Up		0xFF9A
#define VK_KP_Page_Down		0xFF9B
#define VK_KP_End		0xFF9C
#define VK_KP_Insert		0xFF9E
#define VK_KP_Delete		0xFF7F
#define VK_KP_Equal		0xFF3D
#define VK_KP_Multiply		0xFF2A
#define VK_KP_Add		0xFF2B
#define VK_KP_Subtract		0xFF2D
#define VK_KP_Decimal		0xFF2E
#define VK_KP_Divide		0xFF2F

#define VK_KP_0			0xFF30
#define VK_KP_1			0xFF31
#define VK_KP_2			0xFF32
#define VK_KP_3			0xFF33
#define VK_KP_4			0xFF34
#define VK_KP_5			0xFF35
#define VK_KP_6			0xFF36
#define VK_KP_7			0xFF37
#define VK_KP_8			0xFF38
#define VK_KP_9			0xFF39


#define VK_F1			0xFFC1
#define VK_F2			0xFFC2
#define VK_F3			0xFFC3
#define VK_F4			0xFFC4
#define VK_F5			0xFFC5
#define VK_F6			0xFFC6
#define VK_F7			0xFFC7
#define VK_F8			0xFFC8
#define VK_F9			0xFFC9
#define VK_F10			0xFFCA
#define VK_F11			0xFFCB
#define VK_F12			0xFFCC

// The following are modifer keys pressed by themselves

#define VK_Shift		0xFFE1
#define VK_Control		0xFFE4
#define VK_Caps_Lock		0xFFE5
#define VK_Alt			0xFFE9

#define VK_IsModifier(x) (x>=VK_Shift && x<=VK_Alt)

#define VK_space               0x020
#define VK_asciitilde          0x07e
#endif
