/*
 * addon.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __ADDON_H__
#define __ADDON_H__

#include "window.h"

class CalendarView;

class Calendar: public Window
{
protected:
	CalendarView *calview;
public:
	Calendar(int x, int y);
	void handleEvent(Event &event);
};

class CalendarView: public View
{
protected:
	int month;
	int year;
public:
	CalendarView(int x, int y);
	virtual int dayOfWeek(int day, int month, int year);
	void draw();
	virtual void moveDelta(int delta);
};

class Clock: public Window
{
public:
	Clock(int x, int y);
};

class ClockView: public View
{
protected:
	int hour;
	int min;
	int sec;
public:
	ClockView(int x, int y);
	void draw();
	void handleEvent(Event &event);
	virtual void writeSegment(int value, Video *where, int col);
};

#endif
