/*
 * binedit.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __BINEDIT_H__
#define __BINEDIT_H__

#include <limits.h>
#include "window.h"

class BinEditWindow;
class BinEditor;
class ScrollBar;

class BinIndicator: public View
{
protected:
	BinEditor *link;
public:
	BinIndicator(Rect bounds);
	void draw();
	virtual void setLink(BinEditor *alink);
};

class BinEditor: public View
{
	friend BinIndicator;
	friend BinEditWindow;
protected:
	BinIndicator *ind;
	ScrollBar *vs;
	char file[PATH_MAX];
	int current;
	int home;
	int length;
	int modified;
	unsigned char *block;
public:
	BinEditor(int x, int y, char *afile, ScrollBar *avs,
		BinIndicator *aind);
	~BinEditor();
	virtual void adjustValue();
	void draw();
	virtual void enableCommands(int enable);
	void handleEvent(Event &event);
	int isValid(int command);
	virtual int loadFile();
	virtual int maxScroll();
	virtual int saveFile();
	virtual int saveFileAs();
	virtual void trackKey(int keycode);
	virtual int trackMouse(Event &event);
	virtual void updateScreen();
};

class BinEditWindow: public Window
{
protected:
	BinEditor *editor;
public:
	BinEditWindow(int x, int y, char *afile);
	void enableCommands(int enable);
	char *getTitle();
};

#endif
