#
# engine.S
#
# Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
#
# Permission to use, copy, modify, distribute, and sell this software and
# its documentation for any purpose is hereby granted without fee, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.
#
# SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
# EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
# USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
# OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
#

.equ	OF_CENTER_X,	0x00000001	# option flags
.equ	OF_CENTER_Y,	0x00000002
.equ	OF_FIRSTCLICK,	0x00000004
.equ	OF_POSTPROCESS,	0x00000008
.equ	OF_PREPROCESS,	0x00000010
.equ	OF_SCREENLINK,	0x00000020
.equ	OF_SELECTABLE,	0x00000040
.equ	OF_TOPSELECT,	0x00000080

.equ	SF_ACTIVE,	0x00000001	# state flags
.equ	SF_CURSORVIS,	0x00000002
.equ	SF_DELETE,	0x00000004
.equ	SF_DRAGGING,	0x00000008
.equ	SF_EXPOSED,	0x00000010
.equ	SF_FOCUSED,	0x00000020
.equ	SF_MODAL,	0x00000040
.equ	SF_SHADOW,	0x00000080
.equ	SF_VISIBLE,	0x00000100
.equ	SF_ZOOMED,	0x00000200

.equ	VIEW_VMT,	-4
.equ	OWNER,		0		# View data structure
.equ	CURSOR_X,	4
.equ	CURSOR_Y,	8
.equ	ORIGIN_X,	12
.equ	ORIGIN_Y,	16
.equ	SIZE_X,		20
.equ	SIZE_Y,		24
.equ	NEXT,		28
.equ	PREV,		32
.equ	GROWMODE,	36
.equ	OPTIONS,	40
.equ	STATE,		44
.equ	HELPCTX,	48

.equ	GROUP_VMT,	52
.equ	CLIP_A_X,	56		# Group data structure
.equ	CLIP_A_Y,	60
.equ	CLIP_B_X,	64
.equ	CLIP_B_Y,	68
.equ	BUFFER,		72
.equ	CURRENT,	76
.equ	FIRST,		80
.equ	ENDCOMMAND,	84
.equ	LOCKFLAG,	88
.equ	PHASE,		92

#
# This is only for internal use.
#
# Input:
#	eax	y coordinate
#	ebx	x coordinate
#	ecx	row length in characters
#	esi	buffer address
#

.equ    WV_THIS,	8		# this data must be allocated on the
.equ    WV_TARGET,      -4		# stack before call this routine
.equ    WV_BUFTMP,      -8
.equ    WV_OFFSET,      -12

writeview:
	movl    %ebx, WV_OFFSET(%ebp)   # save x
	movl    %esi, WV_BUFTMP(%ebp)   # save buffer address
	addl	%ebx, %ecx              # count += x ==> ecx = x2
	xorl	%edx, %edx
	movl    WV_THIS(%ebp), %esi     # get object address
	orl     %eax, %eax
	jl      wv_end                  # jump if y < 0
	cmpl    SIZE_Y(%esi), %eax
	jge     wv_end                  # jump if y >= size.y
	orl     %ebx, %ebx
	jge     wv_left                 # jump if x >= 0
	xorl    %ebx, %ebx              # set x = 0

wv_left:
	cmpl    SIZE_X(%esi), %ecx
	jle     wv_right                # jump if x2 <= size.x
	movl    SIZE_X(%esi), %ecx      # set x2 = size.x

wv_right:
	cmpl    %ecx, %ebx
	jge     wv_end                  # jump if x >= x2

wv_begin:
	testl   $SF_VISIBLE, STATE(%esi)
	jz      wv_end                  # jump if object is not visible
	cmpl    $0, OWNER(%esi)
	je      wv_end                  # jump if object has no owner
	movl    %esi, WV_TARGET(%ebp)   # save object address
	addl    ORIGIN_Y(%esi), %eax    # y += origin.y
	movl    ORIGIN_X(%esi), %edi
	addl    %edi, %ebx              # x += origin.x
	addl    %edi, %ecx              # x2 += origin.x
	addl    %edi, WV_OFFSET(%ebp)   # offset += origin.x
	movl    OWNER(%esi), %esi       # get owner address
	cmpl    CLIP_A_Y(%esi), %eax
	jl      wv_end                  # jump if y < clip.a.y
	cmpl    CLIP_B_Y(%esi), %eax
	jge     wv_end                  # jump if y >= clip.b.y
	cmpl    CLIP_A_X(%esi), %ebx
	jge     wv_ok_left              # jump if x >= clip.a.x
	movl    CLIP_A_X(%esi), %ebx    # set x = clip.a.x

wv_ok_left:
	cmpl    CLIP_B_X(%esi), %ecx
	jle     wv_ok_right             # jump if x2 <= clip.b.x
	movl    CLIP_B_X(%esi), %ecx    # set x2 = clip.b.x

wv_ok_right:
	cmpl    %ecx, %ebx
	jge     wv_end                  # jump if x >= x2
	movl    FIRST(%esi), %esi       # get first object address

wv_try_next:
	movl    PREV(%esi), %esi
	cmpl    %esi, WV_TARGET(%ebp)
	je	wv_write		# jump if it is the original
	testl   $SF_VISIBLE, STATE(%esi)
	jz      wv_try_next		# jump if object is not visible
	movl    ORIGIN_Y(%esi), %edi
	cmpl    %edi, %eax
	jl      wv_try_next             # jump if y < origin.y
	addl    SIZE_Y(%esi), %edi
	cmpl    %edi, %eax
	jl	wv_continue		# jump if y < origin.y + size.y
	testl 	$SF_SHADOW, STATE(%esi)
	jz	wv_try_next		# jump if no shadow
	addl	shadow_y, %edi
	cmpl	%edi, %eax
	jge	wv_try_next
	movl	ORIGIN_X(%esi), %edi
	addl	shadow_x, %edi
	cmpl	%edi, %ebx
	jge	wv_shadow_ok
	cmpl	%edi, %ecx
	jle	wv_try_next
	call	wv_try_other

wv_shadow_ok:
	addl	SIZE_X(%esi), %edi
	jmp	wv_shadow_entry

wv_continue:
	movl    ORIGIN_X(%esi), %edi
	cmpl    %edi, %ebx
	jge     wv_correct              # jump if x >= origin.x
	cmpl    %edi, %ecx
	jle     wv_try_next             # jump if x2 <= origin.x
	call    wv_try_other

wv_correct:
	addl    SIZE_X(%esi), %edi
	cmpl    %edi, %ebx
	jge	wv_check_shadow		# jump if x >= origin.x + size.x
	cmpl    %edi, %ecx
	jle     wv_end                  # jump if x2 <= origin.x + size.x
	movl    %edi, %ebx              # set x = origin.x + size.x

wv_check_shadow:
	testl	$SF_SHADOW, STATE(%esi)
	jz	wv_try_next
	pushl	%edi
	movl	ORIGIN_Y(%esi), %edi
	addl	shadow_y, %edi
	cmpl	%edi, %eax
	popl	%edi
	jl	wv_try_next
	addl	shadow_x, %edi

wv_shadow_entry:
	cmpl	%edi, %ebx
	jge	wv_try_next
	incl	%edx
	cmpl	%edi, %ecx
	jle	wv_try_next
	call	wv_try_other
	decl	%edx
	jmp     wv_try_next

wv_try_other:
	pushl   WV_TARGET(%ebp)
	pushl   WV_OFFSET(%ebp)
	pushl   %esi
	pushl   %edi
	pushl	%edx
	pushl   %ecx
	pushl   %eax
	movl    %edi, %ecx
	call    wv_try_next
	popl    %eax
	popl    %ecx
	popl	%edx
	popl    %edi
	popl    %esi
	popl    WV_OFFSET(%ebp)
	popl    WV_TARGET(%ebp)
	movl    %edi, %ebx

wv_end:
	ret

wv_write:
	movl    OWNER(%esi), %esi       # get owner address
	movl    BUFFER(%esi), %edi	# get buffer address
	orl	%edx, %edx
	jnz	wv_no_copy		# jump if we draw the shadow
	orl	%edi, %edi
	jz	wv_no_copy		# jump if there is not buffer
	call	wv_copy

wv_no_copy:
	testl	$OF_SCREENLINK, OPTIONS(%esi)
	jz	wv_no_screen		# jump if must write on the screen
	call	wv_screen

wv_no_screen:
	cmpl    $0, LOCKFLAG(%esi)
	je      wv_begin                # jump if the owner is not locked
	ret                             # owner is locked, so exit

	# outputs data in another View

wv_copy:
	pushl   %esi
	pushl	%edx
	pushl   %ecx
	pushl   %eax
	mulw    SIZE_X(%esi)		# eax = y * size.x
	addl    %ebx, %eax		# eax = y * size.x + x
	shll    $1, %eax
	addl    %eax, %edi
	subl    %ebx, %ecx		# x2 -= x ==> ecx = count
	movl    %ebx, %esi
	subl    WV_OFFSET(%ebp), %esi
	shll    $1, %esi
	addl    WV_BUFTMP(%ebp), %esi
	rep
	movsw
	popl    %eax
	popl    %ecx
	popl	%edx
	popl    %esi
	ret

	# outputs data on the screen

wv_screen:
	pushl	%ebp
	pushl   %esi
	pushl   %edi
	pushl	%edx
	pushl   %ecx
	pushl	%ebx
	pushl   %eax
	xorl	%edi, %edi
	cmpl	mouse_y, %eax
	jne	wv_no_hide		# jump if y != mouse_y
	cmpl	mouse_x, %ebx
	jg	wv_no_hide		# jump if x > mouse_x
	cmpl	mouse_x, %ecx
	jle	wv_no_hide		# jump if x2 <= mouse_x
	incl	%edi

wv_no_hide:
	pushl	%edi			# save for later
	pushl	%edx
	mulw    SIZE_X(%esi)		# eax = y * size.x
	addl    %ebx, %eax		# eax = y * size.x + x
	subl    %ebx, %ecx		# x2 -= x ==> ecx = count
	movl    %ebx, %esi
	subl    WV_OFFSET(%ebp), %esi
	shll    $1, %esi
	addl    WV_BUFTMP(%ebp), %esi	# esi = source address
	popl	%edx			# restore
	orl	%edx, %edx
	jz	wv_no_shadow		# jump if do not draw shadow
	movl	%eax, %edi		# setup destination address
	shll	$1, %edi
	addl	screen, %edi
	pushl	%ecx			# writerow(int addr, Video *src,
	pushl	%edi			# int len)
	pushl	%eax			#
	movb	shadow_attr, %ah

wv_do_shadow:
	lodsb
	stosw
	incl	%esi
	loop	wv_do_shadow
	jmp	wv_draw_mouse

wv_no_shadow:
	pushl	%ecx			# writerow(int addr, Video *src,
	pushl	%esi			# int len)
	pushl	%eax			#

wv_draw_mouse:
	call	writerow		# call the C function
	addl	$12, %esp		#
	popl	%edx
	orl	%edx, %edx
	jz	wv_no_show
	pushl	$1			# void mousedraw(int show)
	call	mousedraw		#
	popl	%eax			#

wv_no_show:
	popl    %eax
	popl	%ebx
	popl    %ecx
	popl	%edx
	popl    %edi
	popl    %esi
	popl	%ebp
	ret

#
# void writebuf(View *obj, int x, int y, int w, int h, Video *buf)
#
# Writes the video buffer on the screen.
#

.equ    WB_BUF,         28
.equ    WB_HEIGHT,      24
.equ    WB_WIDTH,       20
.equ    WB_Y,           16
.equ    WB_X,           12

	.globl	writebuf
writebuf:
	enter   $12, $0                 # allocate stack space
	pushl   %ebx
	pushl   %ecx
	pushl   %edi
	pushl   %esi
	cmpl    $0, WB_HEIGHT(%ebp)
	jle     wb_end                  # exit if height <= 0
	cld                             # used later for string operations

wb_begin:
	movl    WB_Y(%ebp), %eax
	movl    WB_X(%ebp), %ebx
	movl    WB_WIDTH(%ebp), %ecx
	movl    WB_BUF(%ebp), %esi
	call    writeview
	movl    WB_WIDTH(%ebp), %eax
	shll    $1, %eax
	addl    %eax, WB_BUF(%ebp)      # move to next row in buffer
	incl    WB_Y(%ebp)
	decl    WB_HEIGHT(%ebp)
	jnz     wb_begin

wb_end:
	popl    %esi
	popl    %edi
	popl    %ecx
	popl    %ebx
	leave
	ret

#
# void writeline(View *obj, int x, int y, int w, int h, Video *buf)
#
# Writes one line of the video buffer on the screen multiple times.
#

.equ    WL_BUF,         28
.equ    WL_HEIGHT,      24
.equ    WL_WIDTH,       20
.equ    WL_Y,           16
.equ    WL_X,           12

	.globl	writeline
writeline:
	enter   $12, $0                 # allocate stack space
	pushl   %ebx
	pushl   %ecx
	pushl   %edi
	pushl   %esi
	cmpl    $0, WL_HEIGHT(%ebp)
	jle     wl_end                  # exit if height <= 0
	cld                             # used later for string operations

wl_begin:
	movl    WL_Y(%ebp), %eax
	movl    WL_X(%ebp), %ebx
	movl    WL_WIDTH(%ebp), %ecx
	movl    WL_BUF(%ebp), %esi
	call    writeview
	incl    WL_Y(%ebp)
	decl    WL_HEIGHT(%ebp)
	jnz     wl_begin

wl_end:
	popl    %esi
	popl    %edi
	popl    %ecx
	popl    %ebx
	leave
	ret

#
# int isexposed(View *obj)
#
# Returns nonzero if the object is visible on the screen.
#

.equ    IE_THIS,	8
.equ    IE_TARGET,	-4

	.globl	isexposed
isexposed:
	enter   $4, $0			# allocate stack space
	pushl   %ebx
	pushl   %ecx
	pushl   %edi
	pushl   %esi
	movl    IE_THIS(%ebp), %edi     # get object address
	testl   $SF_EXPOSED, STATE(%edi)
	jz      ie_false                # jump if object not exposed
	xorl    %eax, %eax
	cmpl    SIZE_X(%edi), %eax
	jge     ie_false                # jump if size.x <= 0
	cmpl    SIZE_Y(%edi), %eax
	jge     ie_false                # jump if size.y <= 0

ie_begin:
	xorl    %ebx, %ebx              # x = 0
	movl    SIZE_X(%edi), %ecx      # ecx = x2 = size.x
	pushl   %eax                    # store y
	call    ie_check_row
	popl    %eax
	jnc     ie_true                 # no carry ==> object exposed
	movl    IE_THIS(%ebp), %edi     # get object address
	incl    %eax
	cmpl    SIZE_Y(%edi), %eax
	jl      ie_begin                # loop from 0 to size.y - 1

ie_false:
	xorl    %eax, %eax              # not exposed
	popl    %esi
	popl    %edi
	popl    %ecx
	popl    %ebx
	leave
	ret

ie_true:
	movl    $1, %eax                # exposed
	popl    %esi
	popl    %edi
	popl    %ecx
	popl    %ebx
	leave
	ret

ie_out:
	stc                             # set carry because not exposed

ie_end:
	ret

ie_check_owner:
	movl    OWNER(%edi), %edi
	cmpl    $0, BUFFER(%edi)
	jne     ie_end

ie_check_row:
	movl    %edi, IE_TARGET(%ebp)
	addl    ORIGIN_Y(%edi), %eax    # y += origin.y
	movl    ORIGIN_X(%edi), %esi
	addl    %esi, %ebx              # x += owner->origin.x
	addl    %esi, %ecx              # x2 += owner->origin.x
	movl    OWNER(%edi), %edi       # get owner address
	orl     %edi, %edi
	jz      ie_end                  # jump if owner not exists
	cmpl    CLIP_A_Y(%edi), %eax
	jl      ie_out                  # y < clip.a.y ==> not exposed
	cmpl    CLIP_B_Y(%edi), %eax
	jge     ie_out                  # y >= clip.b.y ==> not exposed
	cmpl    CLIP_A_X(%edi), %ebx
	jge     ie_left                 # jump if x >= clip.a.x
	movl    CLIP_A_X(%edi), %ebx    # set x = clip.a.x

ie_left:
	cmpl    CLIP_B_X(%edi), %ecx
	jle     ie_right                # jump if x2 <= clip.b.x
	movl    CLIP_B_X(%edi), %ecx    # set x2 = clip.b.x

ie_right:
	cmpl    %ecx, %ebx
	jge     ie_out                  # jump if x >= x2
	movl    FIRST(%edi), %edi       # get first object address

ie_try_next:
	movl    PREV(%edi), %edi
	cmpl    %edi, IE_TARGET(%ebp)
	je      ie_check_owner          # jump if it is the original
	testl   $SF_VISIBLE, STATE(%edi)
	jz      ie_try_next             # jump if object is not visible
	movl    ORIGIN_Y(%edi), %esi
	cmpl    %esi, %eax
	jl      ie_try_next             # jump if y < origin.y
	addl    SIZE_Y(%edi), %esi
	cmpl    %esi, %eax
	jge     ie_try_next             # jump if y >= origin.y + size.y
	movl    ORIGIN_X(%edi), %esi
	cmpl    %esi, %ebx
	jl      ie_min                  # jump if x < origin.x
	addl    SIZE_X(%edi), %esi
	cmpl    %esi, %ebx
	jge     ie_try_next             # jump if x >= origin.x + size.x
	movl    %esi, %ebx              # set x = origin.x + size.x
	cmpl    %ecx, %ebx
	jl      ie_try_next             # jump if x < x2
	stc
	ret                             # a point exposed ==> object exposed

ie_min:
	cmpl    %esi, %ecx
	jle     ie_try_next             # jump if x2 <= origin.x
	addl    SIZE_X(%edi), %esi
	cmpl    %esi, %ecx
	jg      ie_try_other            # jump if x2 > origin.x + size.x
	movl    ORIGIN_X(%edi), %ecx    # set x2 = origin.x
	jmp     ie_try_next

ie_try_other:
	pushl   IE_TARGET(%ebp)
	pushl   %edi
	pushl   %esi
	pushl   %ecx
	pushl   %eax
	movl    ORIGIN_X(%edi), %ecx
	call    ie_try_next
	popl    %eax
	popl    %ecx
	popl    %ebx
	popl    %edi
	popl    IE_TARGET(%ebp)
	jc      ie_try_next
	ret

#
# void resetcursor(View *obj)
#
# Shows or hides the cursor of the object.
#

.equ	RC_THIS,	24

	.globl	resetcursor
resetcursor:
	pushl	%ebx
	pushl	%ecx
	pushl	%edx
	pushl	%edi
	pushl	%esi
	movl	RC_THIS(%esp), %edi
	movl	STATE(%edi), %eax
	notl	%eax
	testl	$SF_CURSORVIS + SF_FOCUSED + SF_VISIBLE, %eax
	jnz	rc_invisible
	movl	CURSOR_X(%edi), %ecx
	movl	CURSOR_Y(%edi), %eax

rc_beg:
	orl	%ecx, %ecx
	jl	rc_invisible		# jump if x < 0
	cmpl	SIZE_X(%edi), %ecx
	jge	rc_invisible		# jump if x >= size.x
	orl	%eax, %eax
	jl	rc_invisible		# jump if y < 0
	cmpl	SIZE_Y(%edi), %eax
	jge	rc_invisible		# jump if y >= size.y
	addl	ORIGIN_X(%edi), %ecx
	addl	ORIGIN_Y(%edi), %eax
	movl	%edi, %esi
	movl	OWNER(%edi), %edi	# get the owner address
	orl	%edi, %edi
	jz	rc_visible		# jump if no owner
	testl 	$SF_VISIBLE, STATE(%edi)
	jz	rc_invisible		# jump if the owner is invisible
	movl	FIRST(%edi), %ebx	# get the first object in the owner

rc_check:
	movl	PREV(%ebx), %ebx
	cmpl	%ebx, %esi
	je	rc_beg			# jump if it is the same
	testl	$SF_VISIBLE, STATE(%ebx)
	jz	rc_check		# jump if the other is invisible
	movl	ORIGIN_X(%ebx), %edx
	cmpl	%edx, %ecx
	jl	rc_check		# jump if x < origin.x
	addl	SIZE_X(%ebx), %edx
	cmpl	%edx, %ecx
	jge	rc_check		# jump if x >= origin.x + size.x
	movl	ORIGIN_Y(%ebx), %edx
	cmpl	%edx, %eax
	jl	rc_check		# jump if y < origin.y
	addl	SIZE_Y(%ebx), %edx
	cmpl	%edx, %eax
	jge	rc_check		# jump if y >= origin.y + size.y

rc_invisible:
	pushl	screen_height		# setcuraddr(int x, int y)
	pushl	screen_width		#
	call	setcuraddr		#
	addl	$8, %esp		#
	jmp	rc_end

rc_visible:
	pushl	%eax			# setcuraddr(int x, int y)
	pushl	%ecx			#
	call	setcuraddr		#
	addl	$8, %esp		#

rc_end:
	popl	%esi
	popl	%edi
	popl	%edx
	popl	%ecx
	popl	%ebx
	ret
