/*
 * fedit.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __FEDIT_H__
#define __FEDIT_H__

#include <limits.h>
#include "editor.h"
#include "window.h"

class EditWindow;

class FileEditor: public Editor
{
	friend EditWindow;
protected:
	char file[PATH_MAX];
public:
	FileEditor(Rect bounds, ScrollBar *hs, ScrollBar *vs, Indicator *ind,
		char *afile);
	void enableCommands(int enable);
	void handleEvent(Event &event);
	int isValid(int command);
	virtual int loadFile();
	virtual int saveFile();
	virtual int saveFileAs();
	virtual int saveFileNamed();
};

class EditWindow: public Window
{
protected:
	FileEditor *editor;
public:
	EditWindow(Rect bounds, char *file, FileEditor *(*peditor)(Rect,
		ScrollBar *, ScrollBar *, Indicator *, char *));
	void doClose();
	void enableCommands(int enable);
	char *getTitle();
	static FileEditor *initFileEditor(Rect bounds, ScrollBar *hs,
		ScrollBar *vs, Indicator *ind, char *file);
	void sizeLimits(Point &min, Point &max);
};

#endif
