/*
 * inpline.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __INPLINE_H__
#define __INPLINE_H__

#include "venus.h"

struct InputLineData
{
	char value[MAX_WIDTH];
};

class InputLine: public View
{
protected:
	InputLineData data;
	int curpos;
	int firstpos;
	int maxlen;
public:
	InputLine(Rect bounds, char *avalue, int amaxlen = MAX_WIDTH - 1);
	int dataSize();
	void draw();
	void getData(void *buf);
	virtual char *getString();
	void handleEvent(Event &event);
	void setData(void *buf);
	virtual void setString(char *avalue);
};

#endif
