/*
 * menubar.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __MENUBAR_H__
#define __MENUBAR_H__

#include "venus.h"

class MenuItem;

class MenuView: public View
{
protected:
	MenuItem *current;
	MenuItem *menu;
	MenuView *parentmenu;
public:
	MenuView(Rect bounds, MenuItem *amenu, MenuView *aparentmenu);
	virtual void destroyMenu(MenuItem *menu);
	virtual int doSelect(Event &event);
	virtual MenuItem *findHotKey(MenuItem *menu, int keycode);
	virtual MenuItem *findItem(int keycode);
	virtual void getItemRect(MenuItem *find, Rect &rect) = 0;
	void handleEvent(Event &event);
	virtual void handleKey(Event &event, int &action, int &result);
	virtual void handleMouse(Event &event, int &action);
	virtual int mouseInMenus(Event &event);
	virtual int mouseInOwner(Event &event);
	virtual MenuView *newSubView(Rect bounds, MenuItem *menu);
	virtual MenuView *topMenu();
	virtual void trackKey(int forward);
	virtual int trackMouse(Event &event);
};

class MenuBar: public MenuView
{
public:
	MenuBar(Rect bounds, MenuItem *amenu);
	~MenuBar();
	void draw();
	void getItemRect(MenuItem *find, Rect &rect);
};

class SubMenu: public MenuView
{
public:
	SubMenu(Rect bounds, MenuItem *menu, MenuView *parentmenu);
	void draw();
	void getItemRect(MenuItem *find, Rect &rect);
};

class MenuItem
{
	friend MenuBar;
	friend MenuView;
	friend SubMenu;
protected:
	MenuItem *child;
	MenuItem *next;
	MenuItem *standard;
	char *name;
	char *param;
	int command;
	int keycode;
public:
	MenuItem(char *aname, char *aparam, int akeycode, int acommand,
		MenuItem *achild, MenuItem *anext);
};

inline MenuItem *newItem(char *name, char *param, int keycode, int command,
	MenuItem *next)
{
	return new MenuItem(name, param, keycode, command, NULL, next);
}

inline MenuItem *newLine(MenuItem *next)
{
	return new MenuItem(NULL, NULL, KC_NONE, CM_NONE, NULL, next);
}

inline MenuItem *newSubMenu(char *name, MenuItem *child, MenuItem *next)
{
	return new MenuItem(name, NULL, KC_NONE, CM_NONE, child, next);
}

#endif
