/*
 * progbar.cc
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include "progbar.h"

/*
 * ProgressBar constructor.
 */

ProgressBar::ProgressBar(Rect bounds, int amax): View(bounds)
{
	DEBUG("new ProgressBar at %p\n", this);
	max = amax;
	value = 0;
}

/*
 * Draws the ProgressBar on the screen.
 */

void ProgressBar::draw()
{
	DrawBuf buf;
	char str[MAX_WIDTH];
	int col_left, col_right;
	int mid = max == 0 ? size.x : size.x * value / max;

	if (state & SF_ACTIVE)
	{
		col_left = getColor(C_PROGRESSBAR + 2);
		col_right = getColor(C_PROGRESSBAR + 3);
	}
	else
	{
		col_left = getColor(C_PROGRESSBAR);
		col_right = getColor(C_PROGRESSBAR + 1);
	}
	sprintf(str, "%3d%%", 100 * mid / size.x);
	moveChar(buf, ' ', col_left, mid);
	moveChar(buf + mid, ' ', col_right, size.x - mid);
	moveStr(buf + (size.x - 4) / 2, str, 0);
	writeBuf(0, 0, size.x, size.y, buf);
}

/*
 * Changes the value of the PercentBar.
 */

void ProgressBar::setValue(int avalue)
{
	value = RANGE(avalue, 0, max);
	drawView();
}
