/*
 * scrbar.h
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __SCRBAR_H__
#define __SCRBAR_H__

#include "venus.h"

enum
{
	SB_BIGDOWN,
	SB_BIGUP,
	SB_INDICATOR,
	SB_LITTLEDOWN,
	SB_LITTLEUP,
	SB_OUTSIDE
};

class ScrollBar: public View
{
protected:
	int max;
	int min;
	int pgstp;
	int stp;
	int val;
	unsigned char *codes;
public:
	ScrollBar(Rect bounds);
	void draw();
	virtual void drawPos(int pos);
	virtual int getPartCode(Point pnt);
	virtual int getPos();
	virtual int getValue();
	void handleEvent(Event &event);
	virtual int scrollStep(int part);
	virtual void setParams(int aval, int amin, int amax, int apgstp,
		int astp);
	virtual void setRange(int amin, int amax);
	virtual void setStep(int apgstp, int astp);
	virtual void setValue(int aval);
};

#endif
