/*
 * stattxt.cc
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <string.h>
#include "stattxt.h"

/*
 * StaticText constructor.
 */

StaticText::StaticText(Rect bounds, char *aname): View(bounds)
{
	DEBUG("new StaticText at %p\n", this);
	strncpy2(name, aname, sizeof(name));
}

/*
 * Draws the StaticText on the screen.
 */

void StaticText::draw()
{
	DrawBuf buf;
	int cname = state & SF_ACTIVE ? getColor(C_STATICTEXT + 1) :
		getColor(C_STATICTEXT);

	moveChar(buf, ' ', cname, size.x);
	moveStr(buf, name, cname);
	writeBuf(0, 0, size.x, size.y, buf);
}

/*
 * Returns the address of the string.
 */

char *StaticText::getString()
{
	return name;
}

/*
 * Changes the name of the StaticText.
 */

void StaticText::setString(char *aname)
{
	strncpy2(name, aname, sizeof(name));
	drawView();
}
