/*
 * ste.cc
 *
 * Copyright (C) 1996 Sergio Sigala <ssigala@globalnet.it>
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.
 *
 * SERGIO SIGALA DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SERGIO SIGALA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdlib.h>
#include <venus/addon.h>
#include <venus/binedit.h>
#include <venus/button.h>
#include <venus/desktop.h>
#include <venus/dialogs.h>
#include <venus/fedit.h>
#include <venus/menubar.h>
#include <venus/statline.h>
#include <venus/stattxt.h>

enum
{
	CM_ABOUT = CM_USER,
	CM_CALENDAR,
	CM_CLOCK,
	CM_OPEN_BIN,
	CM_OPEN_TXT
};

class Prog: public Program
{
public:
	Prog();
	void aboutBox();
	void handleEvent(Event &event);
	static MenuBar *initMenuBar(Rect bounds);
	static StatusLine *initStatusLine(Rect bounds);
	void openFile(int text);
};

Prog::Prog(): Program(Prog::initDesktop, Prog::initMenuBar,
	Prog::initStatusLine)
{
	Rect bounds(0, 0, size.x, size.y - 2);
	EditWindow *wnd = new EditWindow(bounds, NULL,
		EditWindow::initFileEditor);

	wnd->setState(SF_VISIBLE, 0);
	desktop->insert(wnd);
	aboutBox();
}

void Prog::aboutBox()
{
	Dialog *dlg = new Dialog(Rect(0, 0, 28, 11), "About");

	dlg->insert(new StaticText(Rect(5, 2, 23, 3), "Simple Text Editor"));
	dlg->insert(new StaticText(Rect(8, 4, 20, 5), "Version " VERSION));
	dlg->insert(new StaticText(Rect(3, 6, 25, 7),
		"(C) 1996 Sergio Sigala"));
	dlg->insert(new Button(Rect(10, 8, 19, 10), "O~K~", CM_OK,
		BF_DEFAULT));
	program->execDialog(dlg, NULL);
}

void Prog::handleEvent(Event &event)
{
	Program::handleEvent(event);
	switch (event.what)
	{
	case EV_COMMAND:
		switch (event.command)
		{
		case CM_ABOUT:
			aboutBox();
			break;
		case CM_CALENDAR:
			desktop->insert(new Calendar(2, 1));
			break;
		case CM_CLOCK:
			desktop->insert(new Clock(4, 2));
			break;
		case CM_OPEN_BIN:
		case CM_OPEN_TXT:
			openFile(event.command == CM_OPEN_TXT);
			break;
		default:
			return;
		}
		clearEvent(event);
	}
}

MenuBar *Prog::initMenuBar(Rect bounds)
{
	bounds.b.y = bounds.a.y + 1;
	return new MenuBar(bounds,
		newSubMenu("~F~ile",
			newItem("~O~pen text", NULL, KC_NONE, CM_OPEN_TXT,
			newItem("Open ~b~inary", NULL, KC_NONE, CM_OPEN_BIN,
			newItem("~S~ave", NULL, KC_NONE, CM_SAVE,
			newItem("Save ~a~s", NULL, KC_NONE, CM_SAVEAS,
			newLine(
			newItem("E~x~it", "Alt-X", KC_METAX, CM_QUIT,
			NULL)))))),
		newSubMenu("~E~ditor",
			newItem("~S~how clipboard", NULL, KC_NONE,
				CM_SHOWCLIPBOARD,
			newItem("~O~ptions", NULL, KC_NONE, CM_SETOPTIONS,
			newLine(
			newItem("~C~opy", NULL, KC_NONE, CM_COPY,
			newItem("Cu~t~", NULL, KC_NONE, CM_CUT,
			newItem("~P~aste", NULL, KC_NONE, CM_PASTE,
			newLine(
			newItem("~F~ind", NULL, KC_NONE, CM_FIND,
			newItem("~R~eplace", NULL, KC_NONE, CM_REPLACE,
			newItem("Search ~a~gain", NULL, KC_NONE,
				CM_SEARCHAGAIN,
			NULL)))))))))),
		newSubMenu("~W~indow",
			newItem("~C~lose", NULL, KC_NONE, CM_CLOSE,
			newItem("~M~ove", NULL, KC_NONE, CM_MOVE,
			newItem("~N~ext", NULL, KC_NONE, CM_NEXT,
			newItem("~P~rev", NULL, KC_NONE, CM_PREV,
			newItem("~R~esize", NULL, KC_NONE, CM_RESIZE,
			newItem("~Z~oom", NULL, KC_NONE, CM_ZOOM,
			NULL)))))),
		newSubMenu("~T~ools",
			newItem("~C~alendar", NULL, KC_NONE, CM_CALENDAR,
			newItem("Cloc~k~", NULL, KC_NONE, CM_CLOCK,
			NULL)),
		newSubMenu("~H~elp",
			newItem("~A~bout", NULL, KC_NONE, CM_ABOUT,
			NULL),
		NULL)))))
	);
}

StatusLine *Prog::initStatusLine(Rect bounds)
{
	bounds.a.y = bounds.b.y - 1;
	return new StatusLine(bounds,
		new StatusDef(0, ~0,
			new StatusKey("~Alt-X~ E~x~it", KC_METAX, CM_QUIT,
			new StatusKey("~O~pen text", MK_META('O'),
				CM_OPEN_TXT,
			new StatusKey("Open ~b~inary", MK_META('B'),
				CM_OPEN_BIN,
			new StatusKey("~S~ave", MK_META('S'), CM_SAVE,
			new StatusKey("Save ~a~s", MK_META('A'), CM_SAVEAS,
			new StatusKey("~F10~ Menu", KC_F10, CM_MENU,
			NULL)))))),
		NULL)
	);
}

void Prog::openFile(int text)
{
	FileDialog *fd = new FileDialog(text ? "Open text file" :
		"Open binary file");
	FileDialogData fdd;

	fdd.file[0] = '\0';
	if (program->execDialog(fd, &fdd) == CM_OK)
	{
		int length;

		if ((length = fileLength(fdd.file)) > 256 * 1024)
		{
			messageBox("File %s is greater than 256kB", fdd.file,
				MF_ERROR | MF_OKBUTTON);
		}
		else
		{
			if (text) desktop->insert(new EditWindow(Rect(0, 0,
				size.x,	size.y - 2), fdd.file,
				EditWindow::initFileEditor));
			else
			{
				if (length < 0) messageBox("File must exist",
					NULL, MF_ERROR | MF_OKBUTTON);
				else desktop->insert(new BinEditWindow(0, 0,
					fdd.file));
			}
		}
	}
}

int main()
{
	Prog p;

	p.run();
	return EXIT_SUCCESS;
}
