/****************
 * autologin.c
 * Copyright (C) James Budiono 2012
 * License: GNU GPL Version 3 or later
 * autologin as root or as a user as specified in /etc/autologin
 * Version 3 - no longer removes the control file, and tolerate \n in that file
 ****************/
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

char *control_file="/etc/autologin";
char *default_user="root";

int main(int argc, char *argv[]) {
	char *login_user = default_user;
	char user[256];
	int  len;
	
	//open control file, if any
	int fd = open(control_file, O_RDONLY);
	
	if (fd != -1) {
		//get the stuff
		len = read (fd, user, sizeof(user)-1);
		close (fd);
		
		// make it null terminated
		user [ len ] = 0;
		
		//if last character is linefeed, remove it
		if (len > 1) {
			len--;
			if ( user [ len ] == '\n' ) user [ len ] = 0;
		}
		
		//if string is not null, use it - otherwise use default
		if (len > 1) login_user = user;
		
		//remove it
		//unlink ( control_file );
	}
	//write (1, login_user, strlen(login_user));
	execlp("login","login","-f",login_user,0);
}
